package com.ximai.mes.wm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.wm.domain.WmIssueHeader;
import com.ximai.mes.wm.domain.WmIssueLine;
import com.ximai.mes.wm.domain.tx.WmIssueLineJoinBean;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产领料单行Mapper接口
 *
 * @date 2022-07-14
 */
public interface WmIssueLineMapper extends BaseMapper<WmIssueLine> {
    /**
     * 查询生产领料单行
     *
     * @param lineId 生产领料单行主键
     * @return 生产领料单行
     */
    WmIssueLine selectWmIssueLineByLineId(Long lineId);

    /**
     * 查询生产领料单行列表
     *
     * @param wmIssueLine 生产领料单行
     * @return 生产领料单行集合
     */
    List<WmIssueLine> selectWmIssueLineList(WmIssueLine wmIssueLine);

    /**
     * 查询生产领料单行列表
     *
     * @param wmIssueLine 生产工单逗号分割的编码
     * @return 生产领料单行集合
     */
    List<WmIssueLine> selectWmIssueLineByIssueIdsList(WmIssueLine wmIssueLine);


    /**
     * 新增生产领料单行
     *
     * @param wmIssueLine 生产领料单行
     * @return 结果
     */
    int insertWmIssueLine(WmIssueLine wmIssueLine);

    /**
     * 修改生产领料单行
     *
     * @param wmIssueLine 生产领料单行
     * @return 结果
     */
    int updateWmIssueLine(WmIssueLine wmIssueLine);

    /**
     * 删除生产领料单行
     *
     * @param lineId 生产领料单行主键
     * @return 结果
     */
    int deleteWmIssueLineByLineId(Long lineId);

    /**
     * 批量删除生产领料单行
     *
     * @param lineIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteWmIssueLineByLineIds(Long[] lineIds);

    int deleteByIssueHeaderId(Long issueId);


    /**
     * 查询生产领料单行列表
     *
     * @param query
     * @return 生产领料单行集合
     */
    @Select(value = "select t1.issue_id, t1.issue_code, t2.*, t3.item_code, t3.item_name, t3.unit_of_measure, t3.specification,t4.total_back_num,t2.pack_no \n" +
            "from wm_issue_header t1\n" +
            "         left join wm_issue_line t2 on t1.issue_id = t2.issue_id\n" +
            "         left join md_item t3 on t2.item_id = t3.item_Id\n" +
            "         left join (select batch_no, pack_no,item_id, sum(back_num) total_back_num\n" +
            "                    from pro_material_return\n" +
            "                    group by batch_no, pack_no,item_id) t4 on t4.batch_no = t2.batch_code and t4.pack_no = t2.pack_no  and  t2.item_id=t4.item_id ${ew.customSqlSegment}")
    List<WmIssueLineJoinBean> selectWmIssueLineJoinList(@Param("ew") QueryWrapper<WmIssueLineJoinBean> query);

    /**
     * 查询生产领料校验列表
     *
     * @param query
     * @return 生产领料单行集合
     */
    @Select(value = "select distinct t1.issue_id, t1.issue_code, t2.*, t3.item_code, t3.item_name\n" +
            "\t, t3.unit_of_measure, t3.specification, t2.pack_no\n" +
            "from wm_issue_header t1\n" +
            "\tleft join wm_issue_line t2 on t1.issue_id = t2.issue_id\n" +
            "\tleft join md_item t3 on t2.item_id = t3.item_Id\n" +
            "\t join (select * from pro_work_order_process_item where workorder_process_id in (\n" +
            "\t\tselect workorder_process_id from pro_work_order_process ${ew.customSqlSegment})\n" +
            "\t) t4 on t4.item_id = t2.item_id where t2.workorder_code in (${query})")
    List<WmIssueLineJoinBean> selectFeedingInspection(@Param("query") String query,
                                                      @Param("ew") QueryWrapper<WmIssueLineJoinBean> query2);


    /**
     * 查询生产领料单行列表
     *
     * @param query
     * @return 生产领料单行集合
     */
    @Select(value = "select wih.*,ptw.task_workunit_id from wm_issue_header wih left join pro_material_request pmr on wih.apply_no = pmr.apply_no left join pro_task_workunit ptw on pmr.task_workunit_id = ptw.task_workunit_id   ${ew.customSqlSegment}")
    List<WmIssueHeader> selectHeaderByQw(@Param("ew") QueryWrapper<WmIssueHeader> query);

    @Select("select * from wm_issue_line ${ew.customSqlSegment}")
    List<WmIssueLine> selectListByQw(@Param("ew") QueryWrapper<WmIssueLine> query);
}
