package com.ximai.mes.wm.domain.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class WmIssueVo extends BaseEntity {

    private static final long serialVersionUID = 7007004267378615015L;
    /**
     * 领料单编号
     */
    @JSONField(name = "")
    private String issueCode;


    /**
     * 领料类型
     */
    @JSONField(name = "")
    private Long issueType;

    /**
     * 申请单
     */
    @JSONField(name = "")
    private String applyNo;

    /**
     * 是的结案
     */
    @Excel(name = "是否结案")
    private String windCase;


    /**
     * 生产工单编码
     */
    @JSONField(name = "")
    private String workorderCode;

    /**
     * 工作中心编码
     */
    private String workstationCode;

    /**
     * pl号
     */
    @JSONField(name = "PLNR")
    private String plNum;

    /**
     * 产品物料编码
     */
    @JSONField(name = "")
    private String itemCode;

    /**
     * sap产品物料编码
     */
    @JSONField(name = "")
    private String sapItemCode;

    /**
     * 领料数量
     */
    @JSONField(name = "")
    private BigDecimal quantityIssued;

    /**
     * 领料批次号
     */
    @JSONField(name = "")
    private String batchCode;

    /**
     * 创建人
     */
    @JSONField(name = "")
    private String createBy;

    /**
     * 项次
     */
    @JSONField(name = "")
    private String packNo;


    /**
     * 物料名称
     */
    @JSONField(name = "")
    private String itemName;


    @JSONField(name = "LGOBE")
    private String warehouseName;


}
