package com.ximai.mes.wm.domain;

import java.math.BigDecimal;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * pad传mes领料单记录标对象 wm_issue_record
 *
 * @author generator
 * @date 2024-04-09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WmIssueRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    @TableId
    private Long issueRecordId;

    /** 领料单ID */
    @Excel(name = "领料单ID")
    private String issueCode;

    /** 领料单名称 */
    @Excel(name = "领料单名称")
    private String issueName;

    /** 领料类型领料或者补料 */
    @Excel(name = "领料类型领料或者补料")
    private String issueType;

    /** 工单号 */
    @Excel(name = "工单号")
    private Long workorderCode;

    /** 物料编码 */
    @Excel(name = "物料编码")
    private String itemCode;

    /** 领料数量 */
    @Excel(name = "领料数量")
    private BigDecimal quantityIssued;

    /** 批次号 */
    @Excel(name = "批次号")
    private String batchCode;

    /** 卷号 */
    @Excel(name = "卷号")
    private String packNo;


}
