package com.ximai.mes.tm.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 刀模版申请单对象 tm_tool_request
 *
 * @author generator
 * @date 2024-02-02
 */
public class TmToolRequestVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    @TableId
    private Long toolRequestId;

    /** 申请单编码 */
    @Excel(name = "申请单编码")
    private String toolRequestCode;

    /** 工序id */
    @Excel(name = "工序id")
    private Long processId;

    /** 作业单元id */
    @Excel(name = "作业单元id")
    private Long workunitId;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    /** 预计开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "预计开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 预计结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "预计结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 申请数量 */
    @Excel(name = "申请数量")
    private Long requestNum;

    /** 编排单号 */
    @Excel(name = "编排单号")
    private String arrangeCode;

    public void setToolRequestId(Long toolRequestId)
    {
        this.toolRequestId = toolRequestId;
    }

    public Long getToolRequestId()
    {
        return toolRequestId;
    }
    public void setToolRequestCode(String toolRequestCode)
    {
        this.toolRequestCode = toolRequestCode;
    }

    public String getToolRequestCode()
    {
        return toolRequestCode;
    }
    public void setProcessId(Long processId)
    {
        this.processId = processId;
    }

    public Long getProcessId()
    {
        return processId;
    }
    public void setWorkunitId(Long workunitId)
    {
        this.workunitId = workunitId;
    }

    public Long getWorkunitId()
    {
        return workunitId;
    }
    public void setRequestDate(Date requestDate)
    {
        this.requestDate = requestDate;
    }

    public Date getRequestDate()
    {
        return requestDate;
    }
    public void setStartTime(Date startTime)
    {
        this.startTime = startTime;
    }

    public Date getStartTime()
    {
        return startTime;
    }
    public void setEndTime(Date endTime)
    {
        this.endTime = endTime;
    }

    public Date getEndTime()
    {
        return endTime;
    }
    public void setRequestNum(Long requestNum)
    {
        this.requestNum = requestNum;
    }

    public Long getRequestNum()
    {
        return requestNum;
    }
    public void setArrangeCode(String arrangeCode)
    {
        this.arrangeCode = arrangeCode;
    }

    public String getArrangeCode()
    {
        return arrangeCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("toolRequestId", getToolRequestId())
            .append("toolRequestCode", getToolRequestCode())
            .append("processId", getProcessId())
            .append("workunitId", getWorkunitId())
            .append("requestDate", getRequestDate())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("requestNum", getRequestNum())
            .append("arrangeCode", getArrangeCode())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
