package com.ximai.mes.tm.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.tm.mapper.TmToolMaintenanceProcessMapper;
import com.ximai.mes.tm.domain.TmToolMaintenanceProcess;
import com.ximai.mes.tm.service.ITmToolMaintenanceProcessService;

/**
 * 维护保养过程Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-02-01
 */
@Service
public class TmToolMaintenanceProcessServiceImpl implements ITmToolMaintenanceProcessService
{
    @Autowired
    private TmToolMaintenanceProcessMapper tmToolMaintenanceProcessMapper;




    /**
     * 查询维护保养过程
     *
     * @param processId 维护保养过程主键
     * @return 维护保养过程
     */
    @Override
    public TmToolMaintenanceProcess selectTmToolMaintenanceProcessByProcessId(Long processId)

    {

        return tmToolMaintenanceProcessMapper.selectTmToolMaintenanceProcessByProcessId(processId);
    }

    /**
     * 查询维护保养过程列表
     *
     * @param tmToolMaintenanceProcess 维护保养过程
     * @return 维护保养过程
     */
    @Override
    public List<TmToolMaintenanceProcess> selectTmToolMaintenanceProcessList(TmToolMaintenanceProcess tmToolMaintenanceProcess)
    {
        return tmToolMaintenanceProcessMapper.selectTmToolMaintenanceProcessList(tmToolMaintenanceProcess);
    }

    /**
     * 新增维护保养过程
     *
     * @param tmToolMaintenanceProcess 维护保养过程
     * @return 结果
     */
    @Override
    public int insertTmToolMaintenanceProcess(TmToolMaintenanceProcess tmToolMaintenanceProcess)
    {
        return tmToolMaintenanceProcessMapper.insertTmToolMaintenanceProcess(tmToolMaintenanceProcess);
    }

    /**
     * 修改维护保养过程
     *
     * @param tmToolMaintenanceProcess 维护保养过程
     * @return 结果
     */
    @Override
    public int updateTmToolMaintenanceProcess(TmToolMaintenanceProcess tmToolMaintenanceProcess)
    {
        return tmToolMaintenanceProcessMapper.updateTmToolMaintenanceProcess(tmToolMaintenanceProcess);
    }

    /**
     * 批量删除维护保养过程
     *
     * @param processIds 需要删除的维护保养过程主键
     * @return 结果
     */
    @Override
    public int deleteTmToolMaintenanceProcessByProcessIds(Long[] processIds)
    {
        return tmToolMaintenanceProcessMapper.deleteTmToolMaintenanceProcessByProcessIds(processIds);
    }

    /**
     * 删除维护保养过程信息
     *
     * @param processId 维护保养过程主键
     * @return 结果
     */
    @Override
    public int deleteTmToolMaintenanceProcessByProcessId(Long processId)
    {
        return tmToolMaintenanceProcessMapper.deleteTmToolMaintenanceProcessByProcessId(processId);
    }
}
