package com.ximai.mes.tm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolRequestUse;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 刀模版领用单Mapper接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface TmToolRequestUseMapper extends BaseMapper<TmToolRequestUse> {
    /**
     * 查询刀模版领用单
     *
     * @param toolRequestUseId 刀模版领用单主键
     * @return 刀模版领用单
     */
    TmToolRequestUse selectTmToolRequestUseByToolRequestUseId(Long toolRequestUseId);

    /**
     * 查询刀模版领用单列表
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 刀模版领用单集合
     */
    List<TmToolRequestUse> selectTmToolRequestUseList(TmToolRequestUse tmToolRequestUse);


    @Select(value = "select * from tm_tool_request_use  ${ew.customSqlSegment}")
    List<TmToolRequestUse> selectListByQw(@Param("ew") QueryWrapper<TmToolRequestUse> qw2);

    /**
     * 新增刀模版领用单
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 结果
     */
    int insertTmToolRequestUse(TmToolRequestUse tmToolRequestUse);

    /**
     * 修改刀模版领用单
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 结果
     */
    int updateTmToolRequestUse(TmToolRequestUse tmToolRequestUse);

    /**
     * 删除刀模版领用单
     *
     * @param toolRequestUseId 刀模版领用单主键
     * @return 结果
     */
    int deleteTmToolRequestUseByToolRequestUseId(Long toolRequestUseId);

    /**
     * 批量删除刀模版领用单
     *
     * @param toolRequestUseIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteTmToolRequestUseByToolRequestUseIds(Long[] toolRequestUseIds);
}
