package com.ximai.mes.tm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolRequest;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 刀模版申请单Mapper接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface TmToolRequestMapper extends BaseMapper<TmToolRequest> {
    /**
     * 查询刀模版申请单
     *
     * @param toolRequestId 刀模版申请单主键
     * @return 刀模版申请单
     */
    TmToolRequest selectTmToolRequestByToolRequestId(Long toolRequestId);

    /**
     * 查询刀模版申请单列表
     *
     * @param tmToolRequest 刀模版申请单
     * @return 刀模版申请单集合
     */
    List<TmToolRequest> selectTmToolRequestList(TmToolRequest tmToolRequest);

    /**
     * 新增刀模版申请单
     *
     * @param tmToolRequest 刀模版申请单
     * @return 结果
     */
    int insertTmToolRequest(TmToolRequest tmToolRequest);

    /**
     * 修改刀模版申请单
     *
     * @param tmToolRequest 刀模版申请单
     * @return 结果
     */
    int updateTmToolRequest(TmToolRequest tmToolRequest);

    /**
     * 删除刀模版申请单
     *
     * @param toolRequestId 刀模版申请单主键
     * @return 结果
     */
    int deleteTmToolRequestByToolRequestId(Long toolRequestId);

    /**
     * 批量删除刀模版申请单
     *
     * @param toolRequestIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteTmToolRequestByToolRequestIds(Long[] toolRequestIds);


    @Select(value = "select * from tm_tool_request ${ew.customSqlSegment}")
    List<TmToolRequest> selectListByQw(@Param("ew") QueryWrapper<TmToolRequest> requestQueryWrapper);
}
