package com.ximai.mes.tm.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolMaintenanceProcess;

/**
 * 刀具维护记录Mapper接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface TmToolMaintenanceProcessMapper extends BaseMapper<TmToolMaintenanceProcess>
{
    /**
     * 查询刀具维护记录
     *
     * @param processId 刀具维护记录主键
     * @return 刀具维护记录
     */
    public TmToolMaintenanceProcess selectTmToolMaintenanceProcessByProcessId(Long processId);
   public TmToolMaintenanceProcess selectTmToolMaintenanceId( Long toolMaintenanceId);
    /**
     * 查询刀具维护记录列表
     *
     * @param tmToolMaintenanceProcess 刀具维护记录
     * @return 刀具维护记录集合
     */
    public List<TmToolMaintenanceProcess> selectTmToolMaintenanceProcessList(TmToolMaintenanceProcess tmToolMaintenanceProcess);

    /**
     * 新增刀具维护记录
     *
     * @param tmToolMaintenanceProcess 刀具维护记录
     * @return 结果
     */
    public int insertTmToolMaintenanceProcess(TmToolMaintenanceProcess tmToolMaintenanceProcess);

    /**
     * 修改刀具维护记录
     *
     * @param tmToolMaintenanceProcess 刀具维护记录
     * @return 结果
     */
    public int updateTmToolMaintenanceProcess(TmToolMaintenanceProcess tmToolMaintenanceProcess);

    /**
     * 删除刀具维护记录
     *
     * @param processId 刀具维护记录主键
     * @return 结果
     */
    public int deleteTmToolMaintenanceProcessByProcessId(Long processId);

    /**
     * 批量删除刀具维护记录
     *
     * @param processIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTmToolMaintenanceProcessByProcessIds(Long[] processIds);
}
