package com.ximai.mes.tm.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolMaintenance;


/**
 * 要维护刀模版Mapper接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface TmToolMaintenanceMapper extends BaseMapper<TmToolMaintenance>
{
    /**
     * 查询要维护刀模版
     *
     * @param toolMaintenanceId 要维护刀模版主键
     * @return 要维护刀模版
     */
    public TmToolMaintenance selectTmToolMaintenanceByToolMaintenanceId(Long toolMaintenanceId);

    /**
     * 查询要维护刀模版列表
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 要维护刀模版集合
     */
    public List<TmToolMaintenance> selectTmToolMaintenanceList(TmToolMaintenance tmToolMaintenance);

    /**
     * 新增要维护刀模版
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 结果
     */
    public int insertTmToolMaintenance(TmToolMaintenance tmToolMaintenance);

    /**
     * 修改要维护刀模版
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 结果
     */
    public int updateTmToolMaintenance(TmToolMaintenance tmToolMaintenance);

    /**
     * 删除要维护刀模版
     *
     * @param toolMaintenanceId 要维护刀模版主键
     * @return 结果
     */
    public int deleteTmToolMaintenanceByToolMaintenanceId(Long toolMaintenanceId);

    /**
     * 批量删除要维护刀模版
     *
     * @param toolMaintenanceIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTmToolMaintenanceByToolMaintenanceIds(Long[] toolMaintenanceIds);
}
