package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 刀模版物料领用单对象 tm_tool_request_use_item
 *
 * @author generator
 * @date 2024-02-02
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TmToolRequestUseItem extends BaseEntity {
    private static final long serialVersionUID = 1L;

    public TmToolRequestUseItem(Long toolRequestUseId) {
        this.toolRequestUseId = toolRequestUseId;
    }

    private Long lifeTime;
    private Long requestNum;
    private Integer quantity;
    private String toolRequestCode;
    /**
     * 主键id
     */
    @TableId
    private Long toolRequestUseItemId;

    /**
     * 刀模版领用单id
     */
    @Excel(name = "刀模版领用单id")
    private Long toolRequestUseId;

    /**
     * 物料id（工装夹具）
     */
    @Excel(name = "物料id", readConverterExp = "工装夹具")
    private Long itemId;

    /**
     * 工装夹具id
     */
    @Excel(name = "工装夹具id")
    private Long toolId;

    /**
     * 物品存放位置
     */
    @Excel(name = "物品存放位置")
    private String location;

    /**
     * 物料名称
     */
    @Excel(name = "物料名称")
    private String itemName;

    /**
     * 工装夹具名称
     */
    @Excel(name = "工装夹具名称")
    @TableField(exist = false)
    private String toolName;

    /**
     * 工装夹具sn编码
     */
    @TableField(exist = false)
    @Excel(name = "工装夹具sn编码")
    private String toolCode;

    @TableField(exist = false)
    private Long processId;


    @TableField(exist = false)
    private BigDecimal estimatedLifeTime;

}
