package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 刀模版物料申请单对象 tm_tool_request_item
 *
 * @author generator
 * @date 2024-02-02
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TmToolRequestItem extends BaseEntity {
    private static final long serialVersionUID = 1L;

    public TmToolRequestItem(Long toolRequestId) {
        this.toolRequestId = toolRequestId;
    }

    private Integer estimatedLifeTime;
    /**
     * 主键id
     */
    @TableId
    private Long toolRequestItemId;

    /**
     * 刀模版申请单id
     */
    @Excel(name = "刀模版申请单id")
    private Long toolRequestId;

    /**
     * 物料id
     */
    @Excel(name = "物料id")
    private Long itemId;

    /**
     * 总数量
     */
    @Excel(name = "总数量")
    private Integer quantity;

    /**
     * 物料id
     */
    private String itemName;

    private Integer isCheck;


    @TableField(exist = false)
    private List<TmTool> tmToolList;


}
