package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 刀模版上下机记录对象 tm_tool_machines_record
 *
 * @author generator
 * @date 2024-02-06
 */
@Data
public class TmToolMachinesRecord extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(exist = false)
    private Long workunitId;
    @TableField(exist = false)
    private Long taskId;
    @TableField(exist = false)
    private String toolRequestUseCode;

    @TableField(exist = false)
    private String workunitName;
    /**
     * 主键ID
     */
    @TableId
    private Long toolMachinesRecordId;

    /**
     * 刀模版上下机主表ID
     */
    @Excel(name = "刀模版上下机主表ID")
    private Long toolMachinesId;


    /**
     * 刀模版上下机主表ID
     */
    @TableField(exist = false)
    private String toolMachinesCode;


    /**
     * 刀模版上下机主表ID
     */
    @TableField(exist = false)
    private String toolMachinesRecordCode;


    /**
     * 刀模版上下机主表ID
     */
    @TableField(exist = false)
    private String toolRequestCode;

    /**
     * 刀模版领用单附表id
     */
    @Excel(name = "刀模版领用单附表id")
    private Long toolRequestUseItemId;

    /**
     * 上下机类型(1上机2下机)
     */
    @Excel(name = "上下机类型(1上机2下机)")
    private Integer type;


    /**
     * 是否入库 (0 未入库,1 已入库)
     */
    @Excel(name = "0 未入库,1 已入库")
    private Integer warehouse;

    @Excel(name = "入库描述")
    private String warehouseDesc;
    /**
     * 上机时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上机时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date upDate;

    /**
     * 下机时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下机时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date downDate;

    //表外数据
    /**
     * 物料名称
     */
    @Excel(name = "物料名称")
    private String itemName;
    //表外数据
    /**
     * 物料名称
     */
    @TableField(exist = false)
    private String itemCode;


    /**
     * 工装夹具名称
     */
    @Excel(name = "工装夹具名称")
    private String toolName;

    /**
     * 工装夹具名称
     */
    @Excel(name = "工装夹具sn(工装夹具编码)")
    private String toolCode;

    /**
     * 上下机类型名称
     */
    @Excel(name = "上下机类型名称")
    private String typeName;

    /**
     * 刀模版领用单id
     */
    @Excel(name = "刀模版领用单id")
    private Long toolRequestUseId;


    @TableField(exist = false)
    private String typeStr;

    @TableField(exist = false)
    private String warehouseStr;

    @TableField(exist = false)
    private String taskCode;

    private List<String> typeList = new ArrayList<>();


    private List<String> warehouseList = new ArrayList<>();

    private List<Long> toolMachinesRecordIdList;


    public String getWarehouseDesc() {
        return warehouseDesc;
    }

    public void setWarehouseDesc(String warehouseDesc) {
        this.warehouseDesc = warehouseDesc;
    }

    public String getWarehouseStr() {
        return warehouseStr;
    }

    public void setWarehouseStr(String warehouseStr) {
        this.warehouseStr = warehouseStr;
    }

    public List<String> getWarehouseList() {
        if (this.warehouseStr != null && !"".equals(this.warehouseStr)) {
            Collections.addAll(warehouseList, warehouseStr.split(","));
        }
        return warehouseList;
    }

    public void setWarehouseList(List<String> warehouseList) {
        this.warehouseList = warehouseList;
    }

    public String getToolMachinesCode() {
        return toolMachinesCode;
    }

    public void setToolMachinesCode(String toolMachinesCode) {
        this.toolMachinesCode = toolMachinesCode;
    }

    public String getToolMachinesRecordCode() {
        return toolMachinesRecordCode;
    }

    public void setToolMachinesRecordCode(String toolMachinesRecordCode) {
        this.toolMachinesRecordCode = toolMachinesRecordCode;
    }

    public String getToolRequestCode() {
        return toolRequestCode;
    }

    public void setToolRequestCode(String toolRequestCode) {
        this.toolRequestCode = toolRequestCode;
    }

    public Integer getWarehouse() {
        return warehouse;
    }

    public void setWarehouse(Integer warehouse) {
        this.warehouse = warehouse;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }


    public String getTypeStr() {
        return typeStr;
    }

    public void setTypeStr(String typeStr) {
        this.typeStr = typeStr;
    }

    public List<String> getTypeList() {
        if (this.typeStr != null && !"".equals(this.typeStr)) {
            Collections.addAll(typeList, typeStr.split(","));
        }
        return typeList;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    public List<Long> getToolMachinesRecordIdList() {
        return toolMachinesRecordIdList;
    }

    public void setToolMachinesRecordIdList(List<Long> toolMachinesRecordIdList) {
        this.toolMachinesRecordIdList = toolMachinesRecordIdList;
    }

    public Long getToolRequestUseId() {
        return toolRequestUseId;
    }

    public void setToolRequestUseId(Long toolRequestUseId) {
        this.toolRequestUseId = toolRequestUseId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getToolName() {
        return toolName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public String getToolCode() {
        return toolCode;
    }

    public void setToolCode(String toolCode) {
        this.toolCode = toolCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setToolMachinesRecordId(Long toolMachinesRecordId) {
        this.toolMachinesRecordId = toolMachinesRecordId;
    }

    public Long getToolMachinesRecordId() {
        return toolMachinesRecordId;
    }

    public void setToolMachinesId(Long toolMachinesId) {
        this.toolMachinesId = toolMachinesId;
    }

    public Long getToolMachinesId() {
        return toolMachinesId;
    }

    public void setToolRequestUseItemId(Long toolRequestUseItemId) {
        this.toolRequestUseItemId = toolRequestUseItemId;
    }

    public Long getToolRequestUseItemId() {
        return toolRequestUseItemId;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public void setUpDate(Date upDate) {
        this.upDate = upDate;
    }

    public Date getUpDate() {
        return upDate;
    }

    public void setDownDate(Date downDate) {
        this.downDate = downDate;
    }

    public Date getDownDate() {
        return downDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("toolMachinesRecordId", getToolMachinesRecordId())
                .append("toolMachinesId", getToolMachinesId())
                .append("toolRequestUseItemId", getToolRequestUseItemId())
                .append("type", getType())
                .append("upDate", getUpDate())
                .append("downDate", getDownDate())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
