package com.ximai.mes.scheduled;

import com.ximai.mes.md.service.IMdClientService;
import com.ximai.mes.md.service.IMdItemService;
import com.ximai.mes.md.service.IMdVendorService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import com.ximai.mes.wm.service.IWmWarehouseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * ERP数据同步
 */
@Component
public class ErpDataSyncScheduled {
    private static Logger logger = LoggerFactory.getLogger(ErpDataSyncScheduled.class);

    @Autowired
    private IMdClientService clientService;
    @Autowired
    private IMdVendorService vendorService;
    @Autowired
    private IProWorkorderService workorderService;
    @Autowired
    private IMdItemService itemService;
    @Autowired
    private IWmWarehouseService warehouseService;

    public void process() {
        try {
            warehouseService.syncErpData();
        }catch (Exception e){
            logger.error("sync warehouse data error:", e);
        }
        try {
            clientService.syncErpData();
        }catch (Exception e){
            logger.error("sync client data error:", e);
        }
        try {
            vendorService.syncErpData();
        }catch (Exception e){
            logger.error("sync vendor data error:", e);
        }
        try {
            itemService.syncErpData();
        }catch (Exception e){
            logger.error("sync item data error:", e);
        }
        try {
            workorderService.syncErpData();
        }catch (Exception e){
            logger.error("sync workorder data error:", e);
        }
    }

}
