package com.ximai.mes.restful;


import com.alibaba.fastjson.JSON;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProAllocationMaterial;
import com.ximai.mes.pro.service.IProAllocationMaterialService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.ximai.common.utils.PageUtils.startPage;

@RestController
@RequestMapping(value = "/apiPda/allocation")
public class PdaAllocationRestController extends BaseController {

    @Autowired
    IProAllocationMaterialService proAllocationMaterialService;

    @ApiOperation(value = "pda查看调拨料申请单")
    @RequestMapping(value = "/pdaAllocationCreate", method = RequestMethod.GET)
    public TableDataInfo allocationCreate(ProAllocationMaterial proAllocationMaterial){


        String allocationCode = proAllocationMaterial.getApplyNo();
        if(Objects.equals(allocationCode, "") || StringUtils.isEmpty(allocationCode)){
            List<ProAllocationMaterial> proAllocationMaterials = proAllocationMaterialService.selectProAllocationMaterialList(proAllocationMaterial);
            ArrayList<ProAllocationMaterial> proAllocationMaterials1 = new ArrayList<>();
            for(ProAllocationMaterial pro:proAllocationMaterials){
                if(!pro.getWindCase().equals("Y")){
                    proAllocationMaterials1.add(pro);
                }
            }
          return getDataTable(proAllocationMaterials1);
        }else{
            ProAllocationMaterial proAllocation = new ProAllocationMaterial();
            proAllocation.setApplyNo(allocationCode);
            List<ProAllocationMaterial> proAllocationMaterials = proAllocationMaterialService.selectProAllocationMaterialList(proAllocation);
            ArrayList<ProAllocationMaterial> proAllocationMaterials1 = new ArrayList<>();
            for(ProAllocationMaterial pro:proAllocationMaterials){
                if(!pro.getWindCase().equals("Y")){
                    proAllocationMaterials1.add(pro);
                }
            }
            return getDataTable(proAllocationMaterials1);
        }
    }


    @ApiOperation(value = "pda回传mes调拨料数据")
    @RequestMapping(value = "/pdaAllocation", method = RequestMethod.POST)
    public AjaxResult allocationBackhaul(@RequestBody String tmAllocationJson){
        try {
            List<ProAllocationMaterial> proAllocationMaterials = JSON.parseArray(tmAllocationJson, ProAllocationMaterial.class);
            proAllocationMaterialService.insertProAllocationMaterialList(proAllocationMaterials);
        }catch (Exception e){
            AjaxResult.error(e.getMessage());
        }
        return AjaxResult.success("操作成功");
    }



}
