package com.ximai.mes.report.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.report.mapper.MonthlyProductionReportMapper;
import com.ximai.mes.report.mapper.WeeklyProductionReportMapper;
import com.ximai.mes.report.request.WeeklyProductionReportRequest;
import com.ximai.mes.report.service.WeeklyProductionReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.*;

@Service
public class WeeklyProductionReportServiceImp implements WeeklyProductionReportService {
//    private List<String> dateList =new ArrayList<String>(
//            Arrays.asList( "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"));
    @Autowired
    DailyProductionReportServiceImp dailyProductionReportServiceImp;
    @Autowired
    WeeklyProductionReportMapper weeklyProductionReportMapper;
    @Override
    public List getListByProcess(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(weeklyProductionReportRequest.getDateWeekly() == null,
                "请传入年月份");
        List<Map> processDataList = weeklyProductionReportMapper.getListByProcess(weeklyProductionReportRequest);
        List<String> dateList = getWeeks(new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[0]), new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[1]));
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"工序名称","工序编码","工序",dateList);
        return returnList;
    }


    @Override
    public List getListByWorkshop(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(weeklyProductionReportRequest.getDateWeekly() == null,
                "请传入年月份");
        List<Map> processDataList = weeklyProductionReportMapper.getListByWorkshop(weeklyProductionReportRequest);
        List<String> dateList = getWeeks(new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[0]), new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[1]));
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"车间名称","车间编码","车间",dateList);
        return returnList;
    }

    @Override
    public List getListByWorkstation(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(weeklyProductionReportRequest.getDateWeekly() == null,
                "请传入年月份");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = weeklyProductionReportMapper.getListByWorkstation(weeklyProductionReportRequest);
        List<String> dateList = getWeeks(new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[0]), new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[1]));
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"工作中心名称","工作中心编码","工作中心",dateList);
        return returnList;
    }

    @Override
    public List getListByWorkunit(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(weeklyProductionReportRequest.getDateWeekly() == null,
                "请传入年月份");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = weeklyProductionReportMapper.getListByWorkunit(weeklyProductionReportRequest);
        List<String> dateList = getWeeks(new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[0]), new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[1]));
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"工作单元名称","工作单元编码","工作单元",dateList);
        return returnList;
    }

    @Override
    public List getListByUser(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(weeklyProductionReportRequest.getDateWeekly() == null,
                "请传入年月份");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = weeklyProductionReportMapper.getListByUser(weeklyProductionReportRequest);
        List<String> dateList = getWeeks(new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[0]), new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[1]));
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"报工人员名称","报工人员编码","报工人员",dateList);
        return returnList;
    }

    @Override
    public List getDatas(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(weeklyProductionReportRequest.getDateWeekly() == null,
                "请传入年月份");
        List<String> dateList = getWeeks(new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[0]), new Integer(weeklyProductionReportRequest.getDateWeekly().split("-")[1]));
        return dateList;
    }


    public static List<String> getWeeksInMonth(String dateWeekly) {
        dateWeekly = dateWeekly + "-01";
        LocalDate date = LocalDate.parse(dateWeekly);
        LocalDate firstDayOfMonth = date.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate firstDayOfNextMonth = date.with(TemporalAdjusters.firstDayOfNextMonth());
        LocalDate lastDayOfMonth = firstDayOfNextMonth.minusDays(1);

        // 如果月份的第一个星期一之前有足够的天数构成一周，则总周数加一
        if (firstDayOfMonth.getDayOfWeek().getValue() <= firstDayOfMonth.getDayOfMonth()) {
            List<String> data = new ArrayList<>();
            int x = (int) ((lastDayOfMonth.getDayOfMonth() - firstDayOfMonth.getDayOfMonth()) / 7) + 1;
            for (int i = 1 ; i <= x ; i ++){
                data.add(""+i);
            }
            return data;
        } else {
            int x = (int) ((lastDayOfMonth.getDayOfMonth() - firstDayOfMonth.getDayOfMonth()) / 7);
            List<String> data = new ArrayList<>();
            for (int i = 1 ; i <= x ; i ++){
                data.add(""+i);
            }
            return data;
        }
    }

    private List<String> getWeeks(Integer year, Integer month) {
        //天数
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, year);
        c.set(Calendar.MONTH, month -1);
        System.out.println("天数：" + c.getActualMaximum(Calendar.DAY_OF_MONTH));
        int days = c.getActualMaximum(Calendar.DAY_OF_MONTH);
        //月起止时间
        DateTime startTime = null;
        try {
            startTime = DateUtil.beginOfMonth(new SimpleDateFormat("yyyy-MM").parse(year +"-"+ month));
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        int i = DateUtil.dayOfWeek(startTime);
        int firstWeek = 0;
        switch (i){
            case 1 :
                firstWeek = 1;
                break;
            case 2 :
                firstWeek =  7;
                break;
            case 3 :
                firstWeek =  6;
                break;
            case 4 :
                firstWeek =  5;
                break;
            case 5 :
                firstWeek =  4;
                break;
            case 6 :
                firstWeek =  3;
                break;
            case 7 :
                firstWeek =  2;
                break;
        }
        int remainingDays = days - firstWeek;
        int weeks = (int)Math.ceil((double)remainingDays/7) + 1;
        List<String> data = new ArrayList<>();
        for (int x = 1 ; x <= weeks ; x ++){
            data.add(""+x);
        }
        return data;
    }
}
