package com.ximai.mes.report.service;

import com.ximai.common.exception.ServiceException;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/29
 */
@Component
public class UreportCommonData {

    public List<Map<String,Object>> getDetail(String dsName, String databaseName, Map<String,Object> parameters){
        List<Map<String,Object>> rst = new ArrayList<Map<String,Object>>();
        List<Map<String,Object>> detail = new ArrayList<Map<String,Object>>();
        if(!parameters.containsKey(databaseName)){
            throw new ServiceException(String.format("Detail数据集未找到属性：%s", databaseName));
        }
        if(!(parameters.get(databaseName) instanceof List)){
            throw new ServiceException(String.format("请配置数据集属性：%s为数组集合", databaseName));
        }
        detail = (List<Map<String,Object>>)parameters.get(databaseName);
        rst.addAll(detail);
        return rst;
    }

    public List<Map<String,Object>> getHeader(String dsName, String databaseName, Map<String,Object> parameters){
        List<Map<String,Object>> rst = new ArrayList<Map<String,Object>>();
        if(!parameters.containsKey(databaseName)){
            throw new ServiceException(String.format("Header数据集未找到属性：%s", databaseName));
        }
        if(!(parameters.get(databaseName) instanceof Map)){
            throw new ServiceException(String.format("请配置数据集属性：%s为对象集合", databaseName));
        }
        rst.add((Map<String,Object>)parameters.get(databaseName));
        return rst;
    }
}
