package com.ximai.mes.report.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
@Data
public class DailyProductionReportRequest {

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /**
     * 工序ID
     */
    @ApiModelProperty(  "工序ID")
    private Long processId;

    /**
     * 工序编码
     */
    @ApiModelProperty(  "工序编码")
    private String processCode;

    /**
     * 工序编码
     */
    @ApiModelProperty(  "工序名称")
    private String processName;


    /**
     * 车间ID
     */
    @ApiModelProperty("车间ID")
    private Long workshopId;
    @ApiModelProperty("车间名称")
    private String workshopName;




    /**
     * 工作中心ID
     */
    @ApiModelProperty(  "工作中心ID")
    private Long workstationId;


    /**
     * 工作中心名称
     */
    @ApiModelProperty(  "工作中心名称")
    private String workstationName;


    /**
     *
     */
    @ApiModelProperty("工作单元ID")
    private Long workunitId;

    @ApiModelProperty("作业单元名称")
    private String workunitName;



    @ApiModelProperty("报工人员名称")
    private String userName;


    @ApiModelProperty("报工人员昵称")
    private String nickName;




}
