package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 仓库对象 WmWarehouseErpDto
 *
 * @date 2024-10-18
 */
@Data
public class WmWarehouseErpDto
{
    private static final long serialVersionUID = 1L;

    @JsonProperty("mc001")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("仓库编号")
    private String warehouseCode;

    @JsonProperty("mc002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("仓库名称")
    private String warehouseName;

    @JsonProperty("mc003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("工厂编号")
    private String factoryCode;

    @JsonProperty("mc018")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("有效码")
    private String verifyStatus;

    @ApiModelProperty("备注")
    @JsonProperty("mc007")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String remark;
}
