package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 工单对象 ProWorkorderErpDto
 *
 * @date 2024-10-18
 */
@Data
public class ProWorkorderErpDto
{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("工单单别")
    @JsonProperty("ta001")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String workorderType;

    @ApiModelProperty("工单单号")
    @JsonProperty("ta002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String workorderCode;

    @ApiModelProperty("开单日期")
    @JsonProperty("ta003")
    @JsonFormat(pattern = "yyyyMMdd")
    private Date billingDate;

    @ApiModelProperty("产品品号")
    @JsonProperty("ta006")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String productCode;

    @ApiModelProperty("产品品名")
    @JsonProperty("ta034")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String productName;

    @ApiModelProperty("产品规格")
    @JsonProperty("ta035")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String productSpc;

    @ApiModelProperty("单位")
    @JsonProperty("ta007")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String unitOfMeasure;

    @ApiModelProperty("预计开工")
    @JsonProperty("ta009")
    @JsonFormat(pattern = "yyyyMMdd")
    private Date expectStartDate;

    @ApiModelProperty("预计完工")
    @JsonFormat(pattern = "yyyyMMdd")
    @JsonProperty("ta010")
    private Date requestDate;

    @ApiModelProperty("状态码")
    @JsonProperty("ta011")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String erpStatus;

    /**
     * 1:已核准、2:尚待核准、3:不准交易
     */
    @ApiModelProperty("审核码")
    @JsonProperty("ta013")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String verifyStatus;

    @ApiModelProperty("预计产量")
    @JsonProperty("ta015")
    private BigDecimal quantity;

    @ApiModelProperty("订单单别")
    @JsonProperty("ta026")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String orderType;

    @ApiModelProperty("订单单号")
    @JsonProperty("ta027")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String orderCode;

    @ApiModelProperty("订单序号")
    @JsonProperty("ta028")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String orderSerial;

    @ApiModelProperty("备注")
    @JsonProperty("ta029")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String remark;

    @ApiModelProperty("急料")
    @JsonProperty("ta044")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String rushOrder;

    @ApiModelProperty("客户图号")
    @JsonProperty("udf02")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String customerDrawingNo;

    @ApiModelProperty("客户项目号")
    @JsonProperty("udf03")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String customerProjectNo;

    @ApiModelProperty("客户编号")
    @JsonProperty("udf04")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String clientCode;

    @ApiModelProperty("客户简称")
    @JsonProperty("udf05")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String clientName;

    @ApiModelProperty("内部图号")
    @JsonProperty("udf08")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String inDrawingNo;

    @ApiModelProperty("创建时间")
    @JsonProperty("createDate")
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    private Date erpCreateTime;

    @ApiModelProperty("修改时间")
    @JsonProperty("modiDate")
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    private Date erpUpdateTime;

    @ApiModelProperty("预计完工")
    @JsonProperty("moctbDtos")
    private List<ProWorkorderBomErpDto> workorderBomList;
}
