package com.ximai.mes.qt.service;

import com.ximai.mes.qt.domain.QtFactoryQuote;

import java.util.List;

/**
 * 工厂报价Service接口
 *
 * @author yinjinlu
 * @date 2024-01-24
 */
public interface IQtFactoryQuoteService {
    /**
     * 查询工厂报价
     *
     *
     * @param qtFactoryQuote@return 工厂报价
     */
    QtFactoryQuote selectQtFactoryQuoteById(QtFactoryQuote qtFactoryQuote);

    /**
     * 查询工厂报价列表
     *
     * @param qtFactoryQuote 工厂报价
     * @return 工厂报价集合
     */
    List<QtFactoryQuote> selectQtFactoryQuoteList(QtFactoryQuote qtFactoryQuote);

    /**
     * 新增工厂报价
     *
     * @param qtFactoryQuote 工厂报价
     * @return 结果
     */
    int insertQtFactoryQuote(QtFactoryQuote qtFactoryQuote);

    /**
     * 修改工厂报价
     *
     * @param qtFactoryQuote 工厂报价
     * @return 结果
     */
    int updateQtFactoryQuote(QtFactoryQuote qtFactoryQuote);

    /**
     * 批量删除工厂报价
     *
     * @param ids 需要删除的工厂报价主键集合
     * @return 结果
     */
    int deleteQtFactoryQuoteByIds(Long[] ids);

    /**
     * 删除工厂报价信息
     *
     * @param id 工厂报价主键
     * @return 结果
     */
    int deleteQtFactoryQuoteById(Long id);
}
