package com.ximai.mes.qc.service;

import com.ximai.mes.qc.domain.QcMobParam;
import com.ximai.mes.qc.domain.QcTemplate;

import java.util.List;

/**
 * 检测模板Service接口
 *
 * @date 2022-05-17
 */
public interface IQcTemplateService {
    /**
     * 查询检测模板
     *
     * @param id 检测模板主键
     * @return 检测模板
     */
    QcTemplate selectQcTemplateByTemplateId(Long id);

    /**
     * 查询检测模板列表
     *
     * @param qcTemplate 检测模板
     * @return 检测模板集合
     */
    List<QcTemplate> selectQcTemplateList(QcTemplate qcTemplate);

    /**
     * 根据检测类型和产品查找对应的检测模板
     *
     * @param qcTemplate
     */
    QcTemplate selectQcTemplateByItemIdAndQcType(QcTemplate qcTemplate);

    /**
     * 根据物料/产品和检验类型查询对应的检测模板
     *
     * @param param
     * @return
     */
    QcTemplate findTemplateByProductIdAndQcType(QcMobParam param);

    /**
     * 检测模板编号是否唯一
     *
     * @param qcTemplate
     * @return
     */
    String checkTemplateCodeUnique(QcTemplate qcTemplate);

    /**
     * 新增检测模板
     *
     * @param qcTemplate 检测模板
     * @return 结果
     */
    int insertQcTemplate(QcTemplate qcTemplate);

    /**
     * 修改检测模板
     *
     * @param qcTemplate 检测模板
     * @return 结果
     */
    int updateQcTemplate(QcTemplate qcTemplate);

    /**
     * 批量删除检测模板
     *
     * @param ids 需要删除的检测模板主键集合
     * @return 结果
     */
    int deleteQcTemplateByTemplateIds(Long[] ids);

    /**
     * 删除检测模板信息
     *
     * @param id 检测模板主键
     * @return 结果
     */
    int deleteQcTemplateByTemplateId(Long id);
}
