package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.qc.domain.QcTemplateIndex;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 检测模板-检测项Mapper接口
 *
 * @date 2022-05-18
 */
public interface QcTemplateIndexMapper {
    /**
     * 查询检测模板-检测项
     *
     * @param recordId 检测模板-检测项主键
     * @return 检测模板-检测项
     */
    QcTemplateIndex selectQcTemplateIndexById(Long recordId);

    /**
     * 查询检测模板-检测项列表
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 检测模板-检测项集合
     */
    List<QcTemplateIndex> selectQcTemplateIndexList(QcTemplateIndex qcTemplateIndex);

    /**
     * 新增检测模板-检测项
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 结果
     */
    int insertQcTemplateIndex(QcTemplateIndex qcTemplateIndex);

    /**
     * 修改检测模板-检测项
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 结果
     */
    int updateQcTemplateIndex(QcTemplateIndex qcTemplateIndex);

    /**
     * 删除检测模板-检测项
     *
     * @param recordId 检测模板-检测项主键
     * @return 结果
     */
    int deleteQcTemplateIndexById(Long recordId);

    /**
     * 批量删除检测模板-检测项
     *
     * @param recordIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcTemplateIndexByIds(Long[] recordIds);

    /**
     * 根据检测模板ID删除所有检测项
     *
     * @param templateId
     * @return
     */
    int deleteByTemplateId(Long templateId);


    @Select(value = "select qi.*,qci.input_type,qci.index_type from qc_template_process t1  left join qc_template qt on t1.template_id = qt.id inner join ( select pp.*, pw.arrange_code, pw.sap_item_code, mi.item_type_id, mi.item_type_name from pro_work_order_process pp left join pro_workorder pw on pp.workorder_id = pw.workorder_id left join md_item mi on pw.sap_item_code = mi.sap_item_code ) t2 on t1.item_type_id = t2.item_type_id and t1.process_id = t2.process_id left join qc_template_index qi on t1.template_id = qi.template_id left join qc_index qci on qi.index_id = qci.index_id ${ew.customSqlSegment}")
    List<QcTemplateIndex> selectListByQw(@Param("ew") QueryWrapper<QcTemplateIndex> query);
}
