package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.qc.domain.QcIqcLine;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 来料检验单行Mapper接口
 *
 * @date 2022-05-19
 */
public interface QcIqcLineMapper {
    /**
     * 查询来料检验单行
     *
     * @param lineId 来料检验单行主键
     * @return 来料检验单行
     */
    QcIqcLine selectQcIqcLineByLineId(Long lineId);

    /**
     * 查询来料检验单行列表
     *
     * @param qcIqcLine 来料检验单行
     * @return 来料检验单行集合
     */
    List<QcIqcLine> selectQcIqcLineList(QcIqcLine qcIqcLine);


    //@Select(value = "select t1.*,mi.sap_item_code,mit.item_type_code from qc_iqc_line t1 inner join qc_iqc t2 on t1.iqc_id = t2.iqc_id inner join md_item mi on t2.item_code = mi.sap_item_code inner join md_item_type mit on mi.item_type_code = mit.item_type_code  ${ew.customSqlSegment}")
    @Select("select * from qc_iqc_line ${ew.customSqlSegment}")
    List<QcIqcLine> selectListByQw(@Param("ew") QueryWrapper<QcIqcLine> queryProcess);

    /**
     * 新增来料检验单行
     *
     * @param qcIqcLine 来料检验单行
     * @return 结果
     */
    int insertQcIqcLine(QcIqcLine qcIqcLine);

    /**
     * 修改来料检验单行
     *
     * @param qcIqcLine 来料检验单行
     * @return 结果
     */
    int updateQcIqcLine(QcIqcLine qcIqcLine);


    int updateCrMajMinQuantity(QcIqcLine qcIqcLine);

    /**
     * 删除来料检验单行
     *
     * @param lineId 来料检验单行主键
     * @return 结果
     */
    int deleteQcIqcLineByLineId(Long lineId);

    int deleteByIqcId(Long iqcId);

    /**
     * 批量删除来料检验单行
     *
     * @param lineIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcIqcLineByLineIds(Long[] lineIds);
}
