package com.ximai.mes.qc.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 检测模板-工序对象 qc_template_process
 *
 * @author generator
 * @date 2024-02-18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QcTemplateProcess extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 记录ID
     */
    @TableId
    private Long id;

    /**
     * 检测模板ID
     */
    @Excel(name = "检测模板ID")
    private Long templateId;

    @TableField(exist = false)
    private String templateName;

    /**
     * 物料类型ID
     */
    @Excel(name = "物料类型ID")
    private Long itemTypeId;

    /**
     * 物料类型名称
     */
    @Excel(name = "物料类型名称")
    private String itemTypeName;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;
    private String processId;

    /**
     * 最大数量
     */
    @Excel(name = "最大数量")
    private Integer maxNum;

    /**
     * 是否质检确认
     */
    @Excel(name = "是否质检确认")
    private Integer isConfirm;

    /**
     * 是否新品
     */
    @Excel(name = "是否新品")
    private Integer isNewProduct;

    /**
     * 预留字段1
     */
    @Excel(name = "预留字段1")
    private String attr1;

    /**
     * 预留字段2
     */
    @Excel(name = "预留字段2")
    private String attr2;

    /**
     * 预留字段3
     */
    @Excel(name = "预留字段3")
    private Integer attr3;

    /**
     * 预留字段4
     */
    @Excel(name = "预留字段4")
    private Integer attr4;

    /* 
     * templateType
     * 模板类型  0:IPQC 1:IQC
     */
    @Excel(name = "模板类型 0:IPQC  1:IQC")
    private Integer qcType;
}
