package com.ximai.mes.qc.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 检测模板-检测项对象 qc_template_index
 *
 * @date 2022-05-18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class QcTemplateIndex extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private Long processId;
    @TableField(exist = false)
    private String workorderCode;
    @TableField(exist = false)
    private String arrangeCode;
    @TableField(exist = false)
    private String qcTypes;

    /**
     * 记录ID
     */
    private Long id;

    /**
     * 检测模板ID
     */
    @Excel(name = "检测模板ID")
    private Long templateId;

    /**
     * 检测项ID
     */
    @Excel(name = "检测项ID")
    private Long indexId;

    /**
     * 检测项编码
     */
    @Excel(name = "检测项编码")
    private String indexCode;

    /**
     * 检测项名称
     */
    @Excel(name = "检测项名称")
    private String indexName;

    /**
     * 下拉选项值
     */
    private String selectValues;

    /**
     * 检测项类型
     */
    @Excel(name = "检测项类型")
    private String indexType;

    @TableField(exist = false)
    private Integer inputType;

    /**
     * 检测工具
     */
    @Excel(name = "检测工具")
    private String qcTool;

    /**
     * 检测方法
     */
    @Excel(name = "检测方法")
    private String checkMethod;

    /**
     * 标准值
     */
    @Excel(name = "标准值")
    private BigDecimal standerVal;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 误差上限
     */
    @Excel(name = "误差上限")
    private BigDecimal thresholdMax;

    /**
     * 误差下限
     */
    @Excel(name = "误差下限")
    private BigDecimal thresholdMin;

    /**
     * 说明图
     */
    @Excel(name = "说明图")
    private String docUrl;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

}
