package com.ximai.mes.qc.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 过程检验单对象 qc_ipqc
 *
 * @date 2022-08-29
 */
@Data
public class QcIpqc extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 检验单ID
     */
    private Long ipqcId;

    /**
     * 检验单编号
     */
    @Excel(name = "检验单编号")
    private String ipqcCode;

    private String arrangeCode;
    /**
     * 检验单名称
     */
    @Excel(name = "检验单名称")
    private String ipqcName;

    /**
     * 检验类型
     */
    @Excel(name = "检验类型")
    private String ipqcType;

    /**
     * 检验模板ID
     */
    @Excel(name = "检验模板ID")
    private Long templateId;

    private Long sourceDocId;

    @Excel(name = "来源单据类型")
    private String sourceDocType;

    @Excel(name = "来源单据编号")
    private String sourceDocCode;

    private Long sourceLineId;

    @TableField(exist = false)
    /**
     * 工单ID
     */
    @Excel(name = "工单ID")
    private Long workorderId;


    /**
     * 工序ID
     */
    @Excel(name = "工序ID")
    private Long workorderProcessId;

    @TableField(exist = false)

    /**
     * 工单编码
     */
    @Excel(name = "工单编码")
    private String workorderCode;

    @TableField(exist = false)
    /**
     * 工单名称
     */
    @Excel(name = "工单名称")
    private String workorderName;

    /**
     * 任务ID
     */
    @Excel(name = "任务ID")
    private Long taskId;

    /**
     * 任务编号
     */
    @Excel(name = "任务编号")
    private String taskCode;

    /**
     * 任务名称
     */
    @Excel(name = "任务名称")
    private String taskName;

    /**
     * 工作站ID
     */
    @Excel(name = "工作站ID")
    private Long workstationId;

    /**
     * 工作站编号
     */
    @Excel(name = "工作站编号")
    private String workstationCode;

    /**
     * 工作站名称
     */
    @Excel(name = "工作站名称")
    private String workstationName;

    /**
     * 工序ID
     */
    @Excel(name = "工序ID")
    private Long processId;

    /**
     * 工序编码
     */
    @Excel(name = "工序编码")
    private String processCode;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;

    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String itemCode;


    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String sapItemCode;

    /**
     * 产品物料名称
     */
    @Excel(name = "产品物料名称")
    private String itemName;

    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String specification;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 检测数量
     */
    @Excel(name = "检测数量")
    private BigDecimal quantityCheck;

    /**
     * 不合格数
     */
    @Excel(name = "不合格数")
    private BigDecimal quantityUnqualified;

    /**
     * 合格品数量
     */
    @Excel(name = "合格品数量")
    private BigDecimal quantityQualified;

    /**
     * 致命缺陷率
     */
    @Excel(name = "致命缺陷率")
    private BigDecimal crRate;

    /**
     * 严重缺陷率
     */
    @Excel(name = "严重缺陷率")
    private BigDecimal majRate;

    /**
     * 轻微缺陷率
     */
    @Excel(name = "轻微缺陷率")
    private BigDecimal minRate;

    /**
     * 致命缺陷数量
     */
    @Excel(name = "致命缺陷数量")
    private BigDecimal crQuantity;

    /**
     * 严重缺陷数量
     */
    @Excel(name = "严重缺陷数量")
    private BigDecimal majQuantity;

    /**
     * 轻微缺陷数量
     */
    @Excel(name = "轻微缺陷数量")
    private BigDecimal minQuantity;

    /**
     * 检测结果
     */
    @Excel(name = "检测结果")
    private String checkResult;

    /**
     * 检测日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "检测日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inspectDate;

    /**
     * 检测人员
     */
    @Excel(name = "检测人员")
    private String inspector;

    /**
     * 检测人员
     */
    @TableField(exist = false)
    @Excel(name = "检测人员中文")
    private String inspectorNickName;

    /**
     * 单据状态
     */
    @Excel(name = "单据状态")
    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;


    /**
     * 预留字段4
     */
    private Long maxNum;


    private List<QcIpqcLine> qcIpqclineList;

}
