package com.ximai.mes.pro.service.prototypeRequest;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequest;
import com.ximai.mes.pro.domain.vo.ProPrototypeRequestVo;

/**
 * 打样申请Service接口
 *
 * @author zht
 * @date 2024-01-18
 */
public interface IProPrototypeRequestService
{
    /**
     * 查询打样申请
     *
     * @param prototypeRequestId 打样申请主键
     * @return 打样申请
     */
    public ProPrototypeRequestVo selectProPrototypeRequestByPrototypeRequestId(Long prototypeRequestId);

    /**
     * 查询打样申请列表
     *
     * @param proPrototypeRequest 打样申请
     * @return 打样申请集合
     */
    public List<ProPrototypeRequest> selectProPrototypeRequestList(ProPrototypeRequest proPrototypeRequest);

    /**
     * 新增打样申请
     *
     * @param proPrototypeRequest 打样申请
     * @return 结果
     */
    public int insertProPrototypeRequest(ProPrototypeRequestVo proPrototypeRequest);

    /**
     * 修改打样申请
     *
     * @param proPrototypeRequest 打样申请
     * @return 结果
     */
    public int updateProPrototypeRequest(ProPrototypeRequestVo proPrototypeRequest);

    /**
     * 批量删除打样申请
     *
     * @param prototypeRequestIds 需要删除的打样申请主键集合
     * @return 结果
     */
    public int deleteProPrototypeRequestByPrototypeRequestIds(Long[] prototypeRequestIds);

    /**
     * 删除打样申请信息
     *
     * @param prototypeRequestId 打样申请主键
     * @return 结果
     */
    public int deleteProPrototypeRequestByPrototypeRequestId(Long prototypeRequestId);

    /**
     *  修改状态
     * @return
     */
    int updateProPrototypeRequestStatus(ProPrototypeRequest proPrototypeRequest);
}
