package com.ximai.mes.pro.service.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMake;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeVo;

/**
 * 样品制作单Service接口
 *
 * @author zht
 * @date 2024-01-20
 */
public interface IProPrototypeMakeService
{
    /**
     * 查询样品制作单
     *
     * @param prototypeMakeId 样品制作单主键
     * @return 样品制作单
     */
    public ProPrototypeMakeVo selectProPrototypeMakeByPrototypeMakeId(Long prototypeMakeId);

    /**
     * 查询样品制作单列表
     *
     * @param proPrototypeMake 样品制作单
     * @return 样品制作单集合
     */
    public List<ProPrototypeMakeVo> selectProPrototypeMakeList(ProPrototypeMake proPrototypeMake);

    /**
     * 新增样品制作单
     *
     * @param proPrototypeMakeVo 样品制作单
     * @return 结果
     */
    public int insertProPrototypeMake(ProPrototypeMakeVo proPrototypeMakeVo);

    /**
     * 修改样品制作单
     *
     * @param proPrototypeMake 样品制作单
     * @return 结果
     */
    public int updateProPrototypeMake(ProPrototypeMakeVo proPrototypeMake);

    /**
     * 批量删除样品制作单
     *
     * @param prototypeMakeIds 需要删除的样品制作单主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeByPrototypeMakeIds(Long[] prototypeMakeIds);

    /**
     * 删除样品制作单信息
     *
     * @param prototypeMakeId 样品制作单主键
     * @return 结果
     */
    public int deleteProPrototypeMakeByPrototypeMakeId(Long prototypeMakeId);

    /**
     * 状态修改
     */
    int updateProPrototypeMakeStatus(ProPrototypeMake proPrototypeMake);
}
