package com.ximai.mes.pro.service.proWorkOrder;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderBom;

import java.util.List;

/**
 * 生产工单BOMService接口
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface IProWorkOrderBomService {
    /**
     * 查询生产工单BOM
     *
     * @param bomItemId 生产工单BOM主键
     * @return 生产工单BOM
     */
    ProWorkOrderBom selectProWorkOrderBomByBomItemId(Long bomItemId);

    /**
     * 查询生产工单BOM列表
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 生产工单BOM集合
     */
    List<ProWorkOrderBom> selectProWorkOrderBomList(ProWorkOrderBom proWorkOrderBom);

    /**
     * 新增生产工单BOM
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 结果
     */
    int insertProWorkOrderBom(ProWorkOrderBom proWorkOrderBom);

    /**
     * 修改生产工单BOM
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 结果
     */
    int updateProWorkOrderBom(ProWorkOrderBom proWorkOrderBom);

    /**
     * 批量删除生产工单BOM
     *
     * @param bomItemIds 需要删除的生产工单BOM主键集合
     * @return 结果
     */
    int deleteProWorkOrderBomByBomItemIds(Long[] bomItemIds);

    /**
     * 删除生产工单BOM信息
     *
     * @param bomItemId 生产工单BOM主键
     * @return 结果
     */
    int deleteProWorkOrderBomByBomItemId(Long bomItemId);

    void deleteByWorkorderCode(String workorderCode);
}
