package com.ximai.mes.pro.service.impl.prototypeRequest;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.prototypeRequest.*;
import com.ximai.mes.pro.domain.vo.*;
import com.ximai.mes.pro.mapper.prototypeRequest.*;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessQcindexService;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessToolService;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import static com.ximai.common.utils.SecurityUtils.getUsername;

/**
 * 打样申请Service业务层处理
 *
 * @author zht
 * @date 2024-01-18
 */
@Service
public class ProPrototypeRequestServiceImpl implements IProPrototypeRequestService {
    @Autowired
    private ProPrototypeRequestMapper proPrototypeRequestMapper;

    @Autowired
    private ProPrototypeRequestBomMapper proPrototypeRequestBomMapper;

    @Autowired
    private ProPrototypeRequestProcessMapper proPrototypeRequestProcessMapper;

    @Autowired
    private ProPrototypeRequestProcessItemMapper proPrototypeRequestProcessItemMapper;
    @Autowired
    private ProPrototypeRequestProcessToolMapper proPrototypeRequestProcessToolMapper;
    @Autowired
    private ProPrototypeRequestProcessQcindexMapper proPrototypeRequestProcessQcindexMapper;
    @Autowired
    private IProPrototypeRequestProcessToolService proPrototypeRequestProcessToolService;
    @Autowired
    private IProPrototypeRequestProcessQcindexService proPrototypeRequestProcessQcindexService;

    /**
     * 查询打样申请
     *
     * @param prototypeRequestId 打样申请主键
     * @return 打样申请
     */
    @Override
    public ProPrototypeRequestVo selectProPrototypeRequestByPrototypeRequestId(Long prototypeRequestId) {
        ProPrototypeRequestVo proPrototypeRequest = proPrototypeRequestMapper.selectProPrototypeRequestByPrototypeRequestId(prototypeRequestId);
        List<ProPrototypeRequestBom> proPrototypeRequestBomList = proPrototypeRequestBomMapper.selectProPrototypeRequestBomByPrototypeRequestId(prototypeRequestId);
        List<ProPrototypeRequestProcessVo> proPrototypeRequestProcessList = proPrototypeRequestProcessMapper.selectProPrototypeRequestProcessByPrototypeRequestId(prototypeRequestId);

        for (ProPrototypeRequestProcessVo proPrototypeRequestProcess : proPrototypeRequestProcessList) {
            // 根据记录id获取工序明细
            List<ProPrototypeRequestProcessItem> processItemList = proPrototypeRequestProcessItemMapper.selectProPrototypeRequestProcessItemByPrototypeRequestProcessId(proPrototypeRequestProcess.getPrototypeRequestProcessId());
            proPrototypeRequestProcess.setProcessItemList(processItemList);
        }

        ProPrototypeRequestVo proPrototypeRequestVo = new ProPrototypeRequestVo();
        BeanUtils.copyProperties(proPrototypeRequest, proPrototypeRequestVo);
        proPrototypeRequestVo.setBomList(proPrototypeRequestBomList);
        proPrototypeRequestVo.setProcessList(proPrototypeRequestProcessList);

        //查询工装量具
        ProPrototypeRequestProcessTool toolQuery = new ProPrototypeRequestProcessTool();
        toolQuery.setPrototypeRequestId(proPrototypeRequest.getPrototypeRequestId());

        List<ProPrototypeRequestProcessToolVo> toolList = proPrototypeRequestProcessToolService.selectProPrototypeRequestProcessToolVoList(toolQuery);
        Map<Long, List<ProPrototypeRequestProcessToolVo>> toolMap = toolList.stream().collect(Collectors.groupingBy(s->s.getPrototypeRequestProcessId()));
        //查询检验项
        ProPrototypeRequestProcessQcindex qcindexQuery = new ProPrototypeRequestProcessQcindex();
        toolQuery.setPrototypeRequestId(proPrototypeRequest.getPrototypeRequestId());
        List<ProPrototypeRequestProcessQcindexVo> qcindexList = proPrototypeRequestProcessQcindexService.selectProPrototypeRequestProcessQcindexVoList(qcindexQuery);
        Map<Long, List<ProPrototypeRequestProcessQcindexVo>> qcindexMap = qcindexList.stream().collect(Collectors.groupingBy(s->s.getPrototypeRequestProcessId()));
        for (ProPrototypeRequestProcessVo proPrototypeRequestProcess : proPrototypeRequestProcessList) {
            proPrototypeRequestProcess.setToolList(toolMap.getOrDefault(proPrototypeRequestProcess.getPrototypeRequestProcessId(), new ArrayList<ProPrototypeRequestProcessToolVo>()));
            proPrototypeRequestProcess.setQcindexList(qcindexMap.getOrDefault(proPrototypeRequestProcess.getPrototypeRequestProcessId(),new ArrayList<ProPrototypeRequestProcessQcindexVo>()));

        }
        return proPrototypeRequestVo;
    }

    /**
     * 查询打样申请列表
     *
     * @param proPrototypeRequest 打样申请
     * @return 打样申请
     */
    @Override
    public List<ProPrototypeRequest> selectProPrototypeRequestList(ProPrototypeRequest proPrototypeRequest) {
        return proPrototypeRequestMapper.selectProPrototypeRequestList(proPrototypeRequest);
    }

    /**
     * 新增打样申请
     *
     * @return 结果
     */
    @Override
    public int insertProPrototypeRequest(ProPrototypeRequestVo proPrototypeRequestVo) {
        // 获取打样申请主数据
        ProPrototypeRequest proPrototypeRequest = new ProPrototypeRequest();
        BeanUtils.copyProperties(proPrototypeRequestVo, proPrototypeRequest);
        proPrototypeRequest.setCreateTime(DateUtils.getNowDate());
        proPrototypeRequest.setCreateBy(getUsername());
        proPrototypeRequest.setPrototypeRequestStatus(0);
        int i = proPrototypeRequestMapper.insert(proPrototypeRequest);
        //int i = proPrototypeRequestMapper.insertProPrototypeRequest(proPrototypeRequest);
        Long prototypeRequestId = proPrototypeRequest.getPrototypeRequestId();

        // 获取打样申请BOM列表
        List<ProPrototypeRequestBom> bomList = proPrototypeRequestVo.getBomList();
        for (ProPrototypeRequestBom proPrototypeRequestBom : bomList) {
            proPrototypeRequestBom.setPrototypeRequestId(prototypeRequestId);
            proPrototypeRequestBomMapper.insertProPrototypeRequestBom(proPrototypeRequestBom);
        }

        // 获取打样工序
        List<ProPrototypeRequestProcessVo> processList = proPrototypeRequestVo.getProcessList();
        for (ProPrototypeRequestProcessVo proPrototypeRequestProcessVo : processList) {
            proPrototypeRequestProcessVo.setPrototypeRequestId(prototypeRequestId);
            // 保存工序
            ProPrototypeRequestProcess prototypeRequestProcess = proPrototypeRequestProcessVo.getPrototypeRequestProcess(proPrototypeRequestProcessVo);
            proPrototypeRequestProcessMapper.insertProPrototypeRequestProcess(prototypeRequestProcess);
            Long prototypeRequestProcessId = prototypeRequestProcess.getPrototypeRequestProcessId();
            proPrototypeRequestProcessVo.setPrototypeRequestProcessId(prototypeRequestProcessId);
            // 获取工序物料-保存
            List<ProPrototypeRequestProcessItem> proPrototypeRequestProcessItemList = proPrototypeRequestProcessVo.getProcessItemList();
            for (ProPrototypeRequestProcessItem proPrototypeRequestProcessItem : proPrototypeRequestProcessItemList) {
                proPrototypeRequestProcessItem.setPrototypeRequestProcessId(prototypeRequestProcessId);
                proPrototypeRequestProcessItemMapper.insertProPrototypeRequestProcessItem(proPrototypeRequestProcessItem);
            }
            //检验项
            List<ProPrototypeRequestProcessQcindexVo> qcindexList = proPrototypeRequestProcessVo.getQcindexList();
            qcindexList.forEach(s->{
                ProPrototypeRequestProcessQcindex temp = new ProPrototypeRequestProcessQcindex();
                BeanUtil.copyProperties(s, temp);
                temp.setPrototypeRequestId(proPrototypeRequestProcessVo.getPrototypeRequestId());
                temp.setPrototypeRequestProcessId(proPrototypeRequestProcessVo.getPrototypeRequestProcessId());
                proPrototypeRequestProcessQcindexMapper.insertProPrototypeRequestProcessQcindex(temp);
            });
            //工装量具
            List<ProPrototypeRequestProcessToolVo> toolList = proPrototypeRequestProcessVo.getToolList();
            toolList.forEach(s->{
                ProPrototypeRequestProcessTool temp = new ProPrototypeRequestProcessTool();
                BeanUtil.copyProperties(s, temp);
                temp.setPrototypeRequestId(proPrototypeRequest.getPrototypeRequestId());
                temp.setPrototypeRequestProcessId(proPrototypeRequestProcessVo.getPrototypeRequestProcessId());
                proPrototypeRequestProcessToolMapper.insertProPrototypeRequestProcessTool(temp);
            });
        }
        return i;
    }

    /**
     * 修改打样申请
     *
     * @param proPrototypeRequestVo 打样申请
     * @return 结果
     */
    @Override
    public int updateProPrototypeRequest(ProPrototypeRequestVo proPrototypeRequestVo) {
        ProPrototypeRequest proPrototypeRequest = new ProPrototypeRequest();
        BeanUtil.copyProperties(proPrototypeRequestVo, proPrototypeRequest);
        proPrototypeRequest.setUpdateTime(DateUtils.getNowDate());
        proPrototypeRequest.setUpdateBy(getUsername());
        int i = proPrototypeRequestMapper.updateById(proPrototypeRequest);
        List<ProPrototypeRequestProcessVo> processList = proPrototypeRequestVo.getProcessList();
        ProPrototypeRequestProcess processQuery = new ProPrototypeRequestProcess();
        processQuery.setPrototypeRequestId(proPrototypeRequest.getPrototypeRequestId());

        // 获取打样申请BOM列表
        List<ProPrototypeRequestBom> bomList = proPrototypeRequestVo.getBomList();
        ProPrototypeRequestBom productionRequestBom = new ProPrototypeRequestBom();
        productionRequestBom.setPrototypeRequestId(proPrototypeRequestVo.getPrototypeRequestId());
        List<ProPrototypeRequestBom> dbBomList = proPrototypeRequestBomMapper.selectProPrototypeRequestBomList(productionRequestBom);
        if(bomList!=null){
            for (ProPrototypeRequestBom proPrototypeRequestBom : bomList) {
                if(proPrototypeRequestBom.getBomItemId()==null){
                    proPrototypeRequestBom.setPrototypeRequestId(proPrototypeRequest.getPrototypeRequestId());
                    proPrototypeRequestBomMapper.insertProPrototypeRequestBom(proPrototypeRequestBom);
                }else{
                    proPrototypeRequestBomMapper.updateProPrototypeRequestBom(proPrototypeRequestBom);
                }
            }
            dbBomList.forEach(v->{
                if(!bomList.stream().filter(v2->{
                    return v.getBomItemId().equals(v2.getBomItemId());
                }).findFirst().isPresent()){
                    proPrototypeRequestBomMapper.deleteProPrototypeRequestBomByBomItemId(v.getBomItemId());
                };
            });
        }

        List<ProPrototypeRequestProcessVo> processListVoDb = proPrototypeRequestProcessMapper.selectProPrototypeRequestProcessList(processQuery);

        if(processList!=null){
            for (ProPrototypeRequestProcessVo proPrototypeRequestProcessVo : processList) {
                // 保存工序
                ProPrototypeRequestProcess tempProcess = proPrototypeRequestProcessVo.getPrototypeRequestProcess(proPrototypeRequestProcessVo);
                if(tempProcess.getPrototypeRequestProcessId()==null) {
                    tempProcess.setPrototypeRequestId(proPrototypeRequest.getPrototypeRequestId());
                    proPrototypeRequestProcessMapper.insertProPrototypeRequestProcess(tempProcess);
                }else{
                    proPrototypeRequestProcessMapper.updateProPrototypeRequestProcess(tempProcess);
                }

                Long prototypeRequestProcessId = proPrototypeRequestProcessVo.getPrototypeRequestProcessId();
                // 获取工序物料-保存
                List<ProPrototypeRequestProcessItem> proPrototypeRequestProcessItemList = proPrototypeRequestProcessVo.getProcessItemList();
                ProPrototypeRequestProcessItem proPrototypeRequestProcessItemQuery = new ProPrototypeRequestProcessItem();
                proPrototypeRequestProcessItemQuery.setPrototypeRequestProcessId(proPrototypeRequestProcessVo.getPrototypeRequestProcessId());
                List<ProPrototypeRequestProcessItem> proPrototypeRequestProcessItemListDb = proPrototypeRequestProcessItemMapper.selectProPrototypeRequestProcessItemList(proPrototypeRequestProcessItemQuery);
                for (ProPrototypeRequestProcessItem proPrototypeRequestProcessItem : proPrototypeRequestProcessItemList) {
                    proPrototypeRequestProcessItem.setPrototypeRequestProcessId(prototypeRequestProcessId);
                    if(proPrototypeRequestProcessItem.getPrototypeRequestProcessItemId()==null) {
                        proPrototypeRequestProcessItemMapper.insertProPrototypeRequestProcessItem(proPrototypeRequestProcessItem);
                    }else{
                        proPrototypeRequestProcessItemMapper.updateProPrototypeRequestProcessItem(proPrototypeRequestProcessItem);
                    }
                }
                proPrototypeRequestProcessItemListDb.forEach(v->{
                    if(!proPrototypeRequestProcessItemList.stream().filter(v2->{
                        return v.getPrototypeRequestProcessItemId().equals(v2.getPrototypeRequestProcessItemId());
                    }).findFirst().isPresent()){
                        proPrototypeRequestProcessMapper.deleteProPrototypeRequestProcessByPrototypeRequestProcessId(v.getPrototypeRequestProcessItemId());
                    };
                });
                //检验项保存、删除
                List<ProPrototypeRequestProcessQcindexVo> proPrototypeRequestProcessQcindexList = proPrototypeRequestProcessVo.getQcindexList();
                ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindexQuery = new ProPrototypeRequestProcessQcindex();
                proPrototypeRequestProcessQcindexQuery.setPrototypeRequestProcessId(proPrototypeRequestProcessVo.getPrototypeRequestProcessId());
                List<ProPrototypeRequestProcessQcindex> proPrototypeRequestProcessQcindexListDb = proPrototypeRequestProcessQcindexMapper.selectProPrototypeRequestProcessQcindexList(proPrototypeRequestProcessQcindexQuery);
                for (ProPrototypeRequestProcessQcindexVo proPrototypeRequestProcessQcindexVo : proPrototypeRequestProcessQcindexList) {
                    ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex = new ProPrototypeRequestProcessQcindex();
                    BeanUtil.copyProperties(proPrototypeRequestProcessQcindexVo, proPrototypeRequestProcessQcindex);
                    proPrototypeRequestProcessQcindex.setPrototypeRequestId(proPrototypeRequestProcessVo.getPrototypeRequestId());
                    proPrototypeRequestProcessQcindex.setPrototypeRequestProcessId(prototypeRequestProcessId);
                    if(proPrototypeRequestProcessQcindex.getPrototypeRequestProcessQcindexId()==null) {
                        proPrototypeRequestProcessQcindexMapper.insertProPrototypeRequestProcessQcindex(proPrototypeRequestProcessQcindex);
                    }else{
                        proPrototypeRequestProcessQcindexMapper.updateProPrototypeRequestProcessQcindex(proPrototypeRequestProcessQcindex);
                    }
                }
                proPrototypeRequestProcessQcindexListDb.forEach(v->{
                    if(!proPrototypeRequestProcessQcindexList.stream().filter(v2->{
                        return v.getPrototypeRequestProcessQcindexId().equals(v2.getPrototypeRequestProcessQcindexId());
                    }).findFirst().isPresent()){
                        proPrototypeRequestProcessQcindexMapper.deleteProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexId(v.getPrototypeRequestProcessQcindexId());
                    };
                });
                //工装
                List<ProPrototypeRequestProcessToolVo> proPrototypeRequestProcessToolList = proPrototypeRequestProcessVo.getToolList();
                ProPrototypeRequestProcessTool proPrototypeRequestProcessToolQuery = new ProPrototypeRequestProcessTool();
                proPrototypeRequestProcessToolQuery.setPrototypeRequestProcessId(proPrototypeRequestProcessVo.getPrototypeRequestProcessId());
                List<ProPrototypeRequestProcessTool> proPrototypeRequestProcessToolListDb = proPrototypeRequestProcessToolMapper.selectProPrototypeRequestProcessToolList(proPrototypeRequestProcessToolQuery);
                for (ProPrototypeRequestProcessToolVo proPrototypeRequestProcessToolVo : proPrototypeRequestProcessToolList) {
                    ProPrototypeRequestProcessTool proPrototypeRequestProcessTool = new ProPrototypeRequestProcessTool();
                    BeanUtil.copyProperties(proPrototypeRequestProcessToolVo, proPrototypeRequestProcessTool);
                    proPrototypeRequestProcessTool.setPrototypeRequestProcessId(prototypeRequestProcessId);
                    proPrototypeRequestProcessTool.setPrototypeRequestId(proPrototypeRequestVo.getPrototypeRequestId());
                    if(proPrototypeRequestProcessTool.getPrototypeRequestProcessToolId()==null) {
                        proPrototypeRequestProcessToolMapper.insertProPrototypeRequestProcessTool(proPrototypeRequestProcessTool);
                    }else{
                        proPrototypeRequestProcessToolMapper.updateProPrototypeRequestProcessTool(proPrototypeRequestProcessTool);
                    }
                }
                proPrototypeRequestProcessToolListDb.forEach(v->{
                    if(!proPrototypeRequestProcessToolList.stream().filter(v2->{
                        return v.getPrototypeRequestProcessToolId().equals(v2.getPrototypeRequestProcessToolId());
                    }).findFirst().isPresent()){
                        proPrototypeRequestProcessToolMapper.deleteProPrototypeRequestProcessToolByPrototypeRequestProcessToolId(v.getPrototypeRequestProcessToolId());
                    };
                });

            }
            processListVoDb.forEach(v->{
                Optional<ProPrototypeRequestProcessVo> optionalProPrototypeRequestProcessVo = processList.stream().filter(v2->{
                    return v.getPrototypeRequestProcessId().equals(v2.getPrototypeRequestProcessId());
                }).findFirst();
                if(!optionalProPrototypeRequestProcessVo.isPresent()){
                    proPrototypeRequestProcessMapper.deleteProPrototypeRequestProcessByPrototypeRequestProcessId(v.getPrototypeRequestProcessId());
                };
            });

        }
        return i;
    }

    /**
     * 批量删除打样申请
     *
     * @param prototypeRequestIds 需要删除的打样申请主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestByPrototypeRequestIds(Long[] prototypeRequestIds) {
        return proPrototypeRequestMapper.deleteProPrototypeRequestByPrototypeRequestIds(prototypeRequestIds);
    }

    /**
     * 删除打样申请信息
     *
     * @param prototypeRequestId 打样申请主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestByPrototypeRequestId(Long prototypeRequestId) {
        return proPrototypeRequestMapper.deleteProPrototypeRequestByPrototypeRequestId(prototypeRequestId);
    }

    @Override
    public int updateProPrototypeRequestStatus(ProPrototypeRequest proPrototypeRequest) {

        Long prototypeRequestId = proPrototypeRequest.getPrototypeRequestId();
        int prototypeRequestStatus = proPrototypeRequest.getPrototypeRequestStatus();
        return proPrototypeRequestMapper.updateProPrototypeRequestStatus(prototypeRequestId, prototypeRequestStatus);
//        ProPrototypeRequest proPrototypeRequest = proPrototypeRequestMapper.selectProPrototypeRequestByPrototypeRequestId(prototypeRequestId);
//        proPrototypeRequest.setPrototypeRequestStatus(prototypeRequestStatus);
//        return proPrototypeRequestMapper.updateProPrototypeRequest(proPrototypeRequest);
    }
}
