package com.ximai.mes.pro.service.impl.prototypeMake;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdColor;
import com.ximai.mes.md.mapper.MdColorMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBomItem;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;
import com.ximai.mes.pro.domain.prototypeMake.*;
import com.ximai.mes.pro.domain.vo.*;
import com.ximai.mes.pro.mapper.prototypeMake.*;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestMapper;
import com.ximai.mes.pro.service.impl.productionSolution.ProProductionSolutionServiceImpl;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessQcindexService;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessToolService;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import static com.ximai.common.utils.SecurityUtils.getUsername;

/**
 * 样品制作单Service业务层处理
 *
 * @author zht
 * @date 2024-01-20
 */
@Service
public class ProPrototypeMakeServiceImpl implements IProPrototypeMakeService {
    @Autowired
    private ProPrototypeMakeMapper proPrototypeMakeMapper;
    @Autowired
    private ProPrototypeRequestMapper proPrototypeRequestMapper;

    @Autowired
    private ProPrototypeMakeBomMapper proPrototypeMakeBomMapper;

    @Autowired
    private ProPrototypeMakeProcessMapper proPrototypeMakeProcessMapper;

    @Autowired
    private ProPrototypeMakeProcessItemMapper proPrototypeMakeProcessItemMapper;

    @Autowired
    private ProProductionSolutionServiceImpl proProductionSolutionService;

    @Autowired
    private MdColorMapper mdColorMapper;
    @Autowired
    private ProPrototypeMakeProcessToolMapper proPrototypeMakeProcessToolMapper;
    @Autowired
    private ProPrototypeMakeProcessQcindexMapper proPrototypeMakeProcessQcindexMapper;
    @Autowired
    private IProPrototypeMakeProcessToolService proPrototypeMakeProcessToolService;
    @Autowired
    private IProPrototypeMakeProcessQcindexService proPrototypeMakeProcessQcindexService;

    /**
     * 查询样品制作单
     *
     * @param prototypeMakeId 样品制作单主键
     * @return 样品制作单
     */
    @Override
    public ProPrototypeMakeVo selectProPrototypeMakeByPrototypeMakeId(Long prototypeMakeId) {
        ProPrototypeMakeVo proPrototypeMakeVo = proPrototypeMakeMapper.selectProPrototypeMakeByPrototypeMakeId(prototypeMakeId);
        //ProPrototypeRequestVo request = proPrototypeRequestMapper.selectProPrototypeRequestByPrototypeRequestId(proPrototypeMakeVo.getPrototypeRequestId());
        //BeanUtil.copyProperties(request, proPrototypeMakeVo, new String[]{"remark"});
        List<ProPrototypeMakeBom> proPrototypeMakeBomList = proPrototypeMakeBomMapper.selectProPrototypeMakeBomByPrototypeMakeId(prototypeMakeId);
        List<ProPrototypeMakeProcessVo> proPrototypeMakeProcessVoList = proPrototypeMakeProcessMapper.selectProPrototypeMakeProcessByPrototypeMakeId(prototypeMakeId);

        if (proPrototypeMakeProcessVoList.size() > 0) {
            // 获取工序物料信息
            for (ProPrototypeMakeProcessVo proPrototypeMakeProcessVo : proPrototypeMakeProcessVoList) {
                Long prototypeMakeProcessId = proPrototypeMakeProcessVo.getPrototypeMakeProcessId();
                List<ProPrototypeMakeProcessItem> proPrototypeMakeProcessItemList = proPrototypeMakeProcessItemMapper.selectProPrototypeMakeProcessItemByPrototypeMakeProcessId(prototypeMakeProcessId);
                proPrototypeMakeProcessVo.setProcessItemList(proPrototypeMakeProcessItemList);
            }
            proPrototypeMakeVo.setProcessList(proPrototypeMakeProcessVoList);
        }
        // 封装返回
        if (StringUtils.isNotNull(proPrototypeMakeVo.getFrontColorId()))
            proPrototypeMakeVo.setFrontColorName(mdColorMapper.selectMdColorByColorId(proPrototypeMakeVo.getFrontColorId()).getColorName());
        if (StringUtils.isNotNull(proPrototypeMakeVo.getOppositeColorId()))
            proPrototypeMakeVo.setOppositeColorName(mdColorMapper.selectMdColorByColorId(proPrototypeMakeVo.getOppositeColorId()).getColorName());

        proPrototypeMakeVo.setBomList(proPrototypeMakeBomList);

        //查询工装量具
        ProPrototypeMakeProcessTool toolQuery = new ProPrototypeMakeProcessTool();
        toolQuery.setPrototypeMakeId(proPrototypeMakeVo.getPrototypeMakeId());
        List<ProPrototypeMakeProcessToolVo> toolList = proPrototypeMakeProcessToolService.selectProPrototypeMakeProcessToolVoList(toolQuery);
        Map<Long, List<ProPrototypeMakeProcessToolVo>> toolMap = toolList.stream().collect(Collectors.groupingBy(s -> s.getPrototypeMakeProcessId()));
        //查询检验项
        ProPrototypeMakeProcessQcindex qcindexQuery = new ProPrototypeMakeProcessQcindex();
        qcindexQuery.setPrototypeMakeId(proPrototypeMakeVo.getPrototypeMakeId());
        List<ProPrototypeMakeProcessQcindexVo> qcindexList = proPrototypeMakeProcessQcindexService.selectProPrototypeMakeProcessQcindexVoList(qcindexQuery);
        Map<Long, List<ProPrototypeMakeProcessQcindexVo>> qcindexMap = qcindexList.stream().collect(Collectors.groupingBy(s -> s.getPrototypeMakeProcessId()));
        for (ProPrototypeMakeProcessVo proPrototypeMakeProcess : proPrototypeMakeProcessVoList) {
            proPrototypeMakeProcess.setToolList(toolMap.getOrDefault(proPrototypeMakeProcess.getPrototypeMakeProcessId(), new ArrayList<ProPrototypeMakeProcessToolVo>()));
            proPrototypeMakeProcess.setQcindexList(qcindexMap.getOrDefault(proPrototypeMakeProcess.getPrototypeMakeProcessId(), new ArrayList<ProPrototypeMakeProcessQcindexVo>()));

        }

        return proPrototypeMakeVo;
    }

    /**
     * 查询样品制作单列表
     *
     * @param proPrototypeMake 样品制作单
     * @return 样品制作单
     */
    @Override
    public List<ProPrototypeMakeVo> selectProPrototypeMakeList(ProPrototypeMake proPrototypeMake) {
        List<ProPrototypeMakeVo> proPrototypeMakesVoList = proPrototypeMakeMapper.selectProPrototypeMakeList(proPrototypeMake);
        if (proPrototypeMakesVoList.size() > 0) {
            // 获取颜色名称
            for (ProPrototypeMakeVo proPrototypeMakeVo : proPrototypeMakesVoList) {
                if (StringUtils.isNotNull(proPrototypeMakeVo.getFrontColorId())) {
                    MdColor mdColor = mdColorMapper.selectMdColorByColorId(proPrototypeMakeVo.getFrontColorId());
                    if (StringUtils.isNotNull(mdColor)) {
                        String colorName = mdColor.getColorName();
                        proPrototypeMakeVo.setFrontColorName(colorName);
                    }
                }

                if (StringUtils.isNotNull(proPrototypeMakeVo.getOppositeColorId())) {
                    MdColor mdColor = mdColorMapper.selectMdColorByColorId(proPrototypeMakeVo.getOppositeColorId());
                    if (StringUtils.isNotNull(mdColor)) {
                        String colorName = mdColor.getColorName();
                        proPrototypeMakeVo.setOppositeColorName(colorName);
                    }
                }
            }
        }
        return proPrototypeMakesVoList;
    }

    /**
     * 新增样品制作单
     *
     * @param proPrototypeMakeVo 样品制作单
     * @return 结果
     */
    @Override
    public int insertProPrototypeMake(ProPrototypeMakeVo proPrototypeMakeVo) {

        // 获取打样申请主数据
        ProPrototypeMake proPrototypeMake = new ProPrototypeMake();
        BeanUtils.copyProperties(proPrototypeMakeVo, proPrototypeMake);
        proPrototypeMake.setCreateTime(DateUtils.getNowDate());
        proPrototypeMake.setCreateBy(getUsername());
        proPrototypeMake.setPrototypeMakeStatus(0);
        int i = proPrototypeMakeMapper.insert(proPrototypeMake);
        Long prototypeMakeId = proPrototypeMake.getPrototypeMakeId();

        // 获取打样申请BOM列表
        List<ProPrototypeMakeBom> bomList = proPrototypeMakeVo.getBomList();
        for (ProPrototypeMakeBom proPrototypeMakeBom : bomList) {
            proPrototypeMakeBom.setPrototypeMakeId(prototypeMakeId);
            proPrototypeMakeBomMapper.insertProPrototypeMakeBom(proPrototypeMakeBom);
        }

        // 获取打样工序
        List<ProPrototypeMakeProcessVo> processList = proPrototypeMakeVo.getProcessList();
        for (ProPrototypeMakeProcessVo proPrototypeMakeProcessVo : processList) {
            proPrototypeMakeProcessVo.setPrototypeMakeId(prototypeMakeId);
            // 保存工序
            ProPrototypeMakeProcess prototypeMakeProcess = proPrototypeMakeProcessVo.getPrototypeMakeProcess(proPrototypeMakeProcessVo);
            proPrototypeMakeProcessMapper.insertProPrototypeMakeProcess(prototypeMakeProcess);
            Long prototypeMakeProcessId = prototypeMakeProcess.getPrototypeMakeProcessId();
            // 获取工序物料-保存
            List<ProPrototypeMakeProcessItem> proPrototypeMakeProcessItemList = proPrototypeMakeProcessVo.getProcessItemList();
            for (ProPrototypeMakeProcessItem proPrototypeMakeProcessItem : proPrototypeMakeProcessItemList) {
                proPrototypeMakeProcessItem.setPrototypeMakeProcessId(prototypeMakeProcessId);
                proPrototypeMakeProcessItemMapper.insertProPrototypeMakeProcessItem(proPrototypeMakeProcessItem);
            }

            //检验项
            List<ProPrototypeMakeProcessQcindexVo> qcindexList = proPrototypeMakeProcessVo.getQcindexList();
            qcindexList.forEach(s -> {
                ProPrototypeMakeProcessQcindex temp = new ProPrototypeMakeProcessQcindex();
                BeanUtil.copyProperties(s, temp);
                temp.setPrototypeMakeId(proPrototypeMakeProcessVo.getPrototypeMakeId());
                temp.setPrototypeMakeProcessId(prototypeMakeProcess.getPrototypeMakeProcessId());
                proPrototypeMakeProcessQcindexMapper.insertProPrototypeMakeProcessQcindex(temp);
            });
            //工装量具
            List<ProPrototypeMakeProcessToolVo> toolList = proPrototypeMakeProcessVo.getToolList();
            toolList.forEach(s -> {
                ProPrototypeMakeProcessTool temp = new ProPrototypeMakeProcessTool();
                BeanUtil.copyProperties(s, temp);
                temp.setPrototypeMakeId(proPrototypeMake.getPrototypeMakeId());
                temp.setPrototypeMakeProcessId(prototypeMakeProcess.getPrototypeMakeProcessId());
                proPrototypeMakeProcessToolMapper.insertProPrototypeMakeProcessTool(temp);
            });

        }


        return i;
    }

    /**
     * 修改样品制作单
     *
     * @param proPrototypeMakeVo 样品制作单
     * @return 结果
     */
    @Override
    public int updateProPrototypeMake(ProPrototypeMakeVo proPrototypeMakeVo) {
        ProPrototypeMake proPrototypeMake = new ProPrototypeMake();
        BeanUtil.copyProperties(proPrototypeMakeVo, proPrototypeMake);
        proPrototypeMake.setUpdateTime(DateUtils.getNowDate());
        proPrototypeMake.setUpdateBy(getUsername());
        int i = proPrototypeMakeMapper.updateById(proPrototypeMake);

        List<ProPrototypeMakeProcessVo> processList = proPrototypeMakeVo.getProcessList();
        ProPrototypeMakeProcess processQuery = new ProPrototypeMakeProcess();
        processQuery.setPrototypeMakeId(proPrototypeMake.getPrototypeMakeId());

        // 获取打样申请BOM列表
        List<ProPrototypeMakeBom> bomList = proPrototypeMakeVo.getBomList();
        ProPrototypeMakeBom productionRequestBom = new ProPrototypeMakeBom();
        productionRequestBom.setPrototypeMakeId(proPrototypeMakeVo.getPrototypeMakeId());
        List<ProPrototypeMakeBom> dbBomList = proPrototypeMakeBomMapper.selectProPrototypeMakeBomList(productionRequestBom);
        if (bomList != null) {
            for (ProPrototypeMakeBom proPrototypeMakeBom : bomList) {
                if (proPrototypeMakeBom.getBomItemId() == null) {
                    proPrototypeMakeBom.setPrototypeMakeId(proPrototypeMake.getPrototypeMakeId());
                    proPrototypeMakeBomMapper.insertProPrototypeMakeBom(proPrototypeMakeBom);
                } else {
                    proPrototypeMakeBomMapper.updateProPrototypeMakeBom(proPrototypeMakeBom);
                }
            }
            dbBomList.forEach(v -> {
                if (!bomList.stream().filter(v2 -> {
                    return v.getBomItemId().equals(v2.getBomItemId());
                }).findFirst().isPresent()) {
                    proPrototypeMakeBomMapper.deleteProPrototypeMakeBomByBomItemId(v.getBomItemId());
                }
                ;
            });
        }

        List<ProPrototypeMakeProcessVo> processListVoDb = proPrototypeMakeProcessMapper.selectProPrototypeMakeProcessList(processQuery);

        if (processList != null) {
            for (ProPrototypeMakeProcessVo proPrototypeMakeProcessVo : processList) {
                // 保存工序
                ProPrototypeMakeProcess tempProcess = proPrototypeMakeProcessVo.getPrototypeMakeProcess(proPrototypeMakeProcessVo);
                if (tempProcess.getPrototypeMakeProcessId() == null) {
                    tempProcess.setPrototypeMakeId(proPrototypeMakeProcessVo.getPrototypeMakeId());
                    proPrototypeMakeProcessMapper.insertProPrototypeMakeProcess(tempProcess);
                } else {
                    proPrototypeMakeProcessMapper.updateProPrototypeMakeProcess(tempProcess);
                }

                Long prototypeRequestProcessId = proPrototypeMakeProcessVo.getPrototypeMakeProcessId();
                // 获取工序物料-保存
                List<ProPrototypeMakeProcessItem> proPrototypeMakeProcessItemList = proPrototypeMakeProcessVo.getProcessItemList();
                ProPrototypeMakeProcessItem proPrototypeMakeProcessItemQuery = new ProPrototypeMakeProcessItem();
                proPrototypeMakeProcessItemQuery.setPrototypeMakeProcessId(proPrototypeMakeProcessVo.getPrototypeMakeProcessId());
                List<ProPrototypeMakeProcessItem> proPrototypeMakeProcessItemListDb = proPrototypeMakeProcessItemMapper.selectProPrototypeMakeProcessItemList(proPrototypeMakeProcessItemQuery);
                for (ProPrototypeMakeProcessItem proPrototypeMakeProcessItem : proPrototypeMakeProcessItemList) {
                    proPrototypeMakeProcessItem.setPrototypeMakeProcessId(prototypeRequestProcessId);
                    if (proPrototypeMakeProcessItem.getPrototypeMakeProcessItemId() == null) {
                        proPrototypeMakeProcessItemMapper.insertProPrototypeMakeProcessItem(proPrototypeMakeProcessItem);
                    } else {
                        proPrototypeMakeProcessItemMapper.updateProPrototypeMakeProcessItem(proPrototypeMakeProcessItem);
                    }
                }
                proPrototypeMakeProcessItemListDb.forEach(v -> {
                    if (!proPrototypeMakeProcessItemList.stream().filter(v2 -> {
                        return v.getPrototypeMakeProcessItemId().equals(v2.getPrototypeMakeProcessItemId());
                    }).findFirst().isPresent()) {
                        proPrototypeMakeProcessMapper.deleteProPrototypeMakeProcessByPrototypeMakeProcessId(v.getPrototypeMakeProcessItemId());
                    }
                    ;
                });
                //检验项保存、删除
                List<ProPrototypeMakeProcessQcindexVo> proPrototypeMakeProcessQcindexList = proPrototypeMakeProcessVo.getQcindexList();
                ProPrototypeMakeProcessQcindex proPrototypeMakeProcessQcindexQuery = new ProPrototypeMakeProcessQcindex();
                proPrototypeMakeProcessQcindexQuery.setPrototypeMakeProcessId(proPrototypeMakeProcessVo.getPrototypeMakeProcessId());
                List<ProPrototypeMakeProcessQcindex> proPrototypeMakeProcessQcindexListDb = proPrototypeMakeProcessQcindexMapper.selectProPrototypeMakeProcessQcindexList(proPrototypeMakeProcessQcindexQuery);
                for (ProPrototypeMakeProcessQcindexVo proPrototypeMakeProcessQcindexVo : proPrototypeMakeProcessQcindexList) {
                    ProPrototypeMakeProcessQcindex proPrototypeMakeProcessQcindex = new ProPrototypeMakeProcessQcindex();
                    BeanUtil.copyProperties(proPrototypeMakeProcessQcindexVo, proPrototypeMakeProcessQcindex);
                    proPrototypeMakeProcessQcindex.setPrototypeMakeId(proPrototypeMakeProcessVo.getPrototypeMakeId());
                    proPrototypeMakeProcessQcindex.setPrototypeMakeProcessId(prototypeRequestProcessId);
                    if (proPrototypeMakeProcessQcindex.getPrototypeMakeProcessQcindexId() == null) {
                        proPrototypeMakeProcessQcindexMapper.insertProPrototypeMakeProcessQcindex(proPrototypeMakeProcessQcindex);
                    } else {
                        proPrototypeMakeProcessQcindexMapper.updateProPrototypeMakeProcessQcindex(proPrototypeMakeProcessQcindex);
                    }
                }
                proPrototypeMakeProcessQcindexListDb.forEach(v -> {
                    if (!proPrototypeMakeProcessQcindexList.stream().filter(v2 -> {
                        return v.getPrototypeMakeProcessQcindexId().equals(v2.getPrototypeMakeProcessQcindexId());
                    }).findFirst().isPresent()) {
                        proPrototypeMakeProcessQcindexMapper.deleteProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexId(v.getPrototypeMakeProcessQcindexId());
                    }
                    ;
                });
                //工装
                List<ProPrototypeMakeProcessToolVo> proPrototypeMakeProcessToolList = proPrototypeMakeProcessVo.getToolList();
                ProPrototypeMakeProcessTool proPrototypeMakeProcessToolQuery = new ProPrototypeMakeProcessTool();
                proPrototypeMakeProcessToolQuery.setPrototypeMakeProcessId(proPrototypeMakeProcessVo.getPrototypeMakeProcessId());
                List<ProPrototypeMakeProcessTool> proPrototypeMakeProcessToolListDb = proPrototypeMakeProcessToolMapper.selectProPrototypeMakeProcessToolList(proPrototypeMakeProcessToolQuery);
                for (ProPrototypeMakeProcessToolVo proPrototypeMakeProcessToolVo : proPrototypeMakeProcessToolList) {
                    ProPrototypeMakeProcessTool proPrototypeMakeProcessTool = new ProPrototypeMakeProcessTool();
                    BeanUtil.copyProperties(proPrototypeMakeProcessToolVo, proPrototypeMakeProcessTool);
                    proPrototypeMakeProcessTool.setPrototypeMakeProcessId(prototypeRequestProcessId);
                    proPrototypeMakeProcessTool.setPrototypeMakeId(proPrototypeMakeProcessVo.getPrototypeMakeId());
                    if (proPrototypeMakeProcessTool.getPrototypeMakeProcessToolId() == null) {
                        proPrototypeMakeProcessToolMapper.insertProPrototypeMakeProcessTool(proPrototypeMakeProcessTool);
                    } else {
                        proPrototypeMakeProcessToolMapper.updateProPrototypeMakeProcessTool(proPrototypeMakeProcessTool);
                    }
                }
                proPrototypeMakeProcessToolListDb.forEach(v -> {
                    if (!proPrototypeMakeProcessToolList.stream().filter(v2 -> {
                        return v.getPrototypeMakeProcessToolId().equals(v2.getPrototypeMakeProcessToolId());
                    }).findFirst().isPresent()) {
                        proPrototypeMakeProcessToolMapper.deleteProPrototypeMakeProcessToolByPrototypeMakeProcessToolId(v.getPrototypeMakeProcessToolId());
                    }
                    ;
                });

            }
            processListVoDb.forEach(v -> {
                Optional<ProPrototypeMakeProcessVo> optionalProPrototypeMakeProcessVo = processList.stream().filter(v2 -> {
                    return v.getPrototypeMakeProcessId().equals(v2.getPrototypeMakeProcessId());
                }).findFirst();
                if (!optionalProPrototypeMakeProcessVo.isPresent()) {
                    proPrototypeMakeProcessMapper.deleteProPrototypeMakeProcessByPrototypeMakeProcessId(v.getPrototypeMakeProcessId());
                }
                ;
            });

        }

        return i;
    }

    /**
     * 批量删除样品制作单
     *
     * @param prototypeMakeIds 需要删除的样品制作单主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeByPrototypeMakeIds(Long[] prototypeMakeIds) {
        return proPrototypeMakeMapper.deleteProPrototypeMakeByPrototypeMakeIds(prototypeMakeIds);
    }

    /**
     * 删除样品制作单信息
     *
     * @param prototypeMakeId 样品制作单主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeByPrototypeMakeId(Long prototypeMakeId) {
        return proPrototypeMakeMapper.deleteProPrototypeMakeByPrototypeMakeId(prototypeMakeId);
    }

    @Override
    public int updateProPrototypeMakeStatus(ProPrototypeMake proPrototypeMake) {
        Long prototypeMakeId = proPrototypeMake.getPrototypeMakeId();
        int prototypeMakeStatus = proPrototypeMake.getPrototypeMakeStatus();

        // 状态判断 -- 当状态为已完成时,转换为生产版本
        if (prototypeMakeStatus == 1) {
            // 获取全部信息
            ProPrototypeMakeVo proPrototypeMakeVo = this.selectProPrototypeMakeByPrototypeMakeId(prototypeMakeId);
            ProProductionSolutionVo proProductionSolutionVo = new ProProductionSolutionVo();
            BeanUtils.copyProperties(proPrototypeMakeVo, proProductionSolutionVo);
            List<ProPrototypeMakeBom> bomList = proPrototypeMakeVo.getBomList();
            List<ProPrototypeMakeProcessVo> processList = proPrototypeMakeVo.getProcessList();

//            List<ProProductionSolutionBom> proProductionSolutionBomList = new ArrayList<>();
//            for (ProPrototypeMakeBom proPrototypeMakeBom : bomList) {
//                ProProductionSolutionBom proProductionSolutionBom = new ProProductionSolutionBom();
//                BeanUtils.copyProperties(proPrototypeMakeBom, proProductionSolutionBom);
//                proProductionSolutionBomList.add(proProductionSolutionBom);
//            }
//            proProductionSolutionVo.setBomList(proProductionSolutionBomList);
            if (StringUtils.isNotNull(bomList)) {
                // 创建BOM头表
                ProProductionSolutionBomHeadVo proProductionSolutionBomHeadVo = new ProProductionSolutionBomHeadVo();
                // 封装BOM行表
                List<ProProductionSolutionBomItem> proProductionSolutionBomItems = new ArrayList<>();
                for (ProPrototypeMakeBom proPrototypeMakeBom : bomList) {
                    ProProductionSolutionBomItem proProductionSolutionBomItem = new ProProductionSolutionBomItem();
                    BeanUtils.copyProperties(proPrototypeMakeBom, proProductionSolutionBomItem);
//                    proProductionSolutionBomItem.setSapItemCode(proPrototypeMakeBom.getItemCode());
                    proProductionSolutionBomItems.add(proProductionSolutionBomItem);
                }
                proProductionSolutionBomHeadVo.setBomItemList(proProductionSolutionBomItems);
                proProductionSolutionVo.setBomHead(proProductionSolutionBomHeadVo);
            }
            List<ProProductionSolutionProcessVo> proProductionSolutionProcessVoList = new ArrayList<>();
            for (ProPrototypeMakeProcessVo proPrototypeMakeProcessVo : processList) {
                ProProductionSolutionProcessVo proProductionSolutionProcessVo = new ProProductionSolutionProcessVo();
                BeanUtils.copyProperties(proPrototypeMakeProcessVo, proProductionSolutionProcessVo);

                List<ProPrototypeMakeProcessItem> processItemList = proPrototypeMakeProcessVo.getProcessItemList();
                List<ProProductionSolutionProcessItem> proProductionSolutionProcessItems = new ArrayList<>();
                for (ProPrototypeMakeProcessItem proPrototypeMakeProcessItem : processItemList) {
                    ProProductionSolutionProcessItem proProductionSolutionProcessItem = new ProProductionSolutionProcessItem();
                    BeanUtils.copyProperties(proPrototypeMakeProcessItem, proProductionSolutionProcessItem);
                    proProductionSolutionProcessItems.add(proProductionSolutionProcessItem);
                }
                proProductionSolutionProcessVo.setProcessItemList(proProductionSolutionProcessItems);

                //质检项
                List<ProPrototypeMakeProcessQcindexVo> processQcindexList = proPrototypeMakeProcessVo.getQcindexList();
                List<ProProductionSolutionProcessQcindexVo> proProductionSolutionProcessQcindexList = new ArrayList<ProProductionSolutionProcessQcindexVo>();
                for (ProPrototypeMakeProcessQcindexVo qcindexVo : processQcindexList) {
                    ProProductionSolutionProcessQcindexVo proProductionSolutionProcessQcindex = new ProProductionSolutionProcessQcindexVo();
                    BeanUtil.copyProperties(qcindexVo, proProductionSolutionProcessQcindex);
                    proProductionSolutionProcessQcindexList.add(proProductionSolutionProcessQcindex);
                }
                proProductionSolutionProcessVo.setQcindexList(proProductionSolutionProcessQcindexList);
                //工装量具
                List<ProPrototypeMakeProcessToolVo> processToolist = proPrototypeMakeProcessVo.getToolList();
                List<ProProductionSolutionProcessToolVo> proProductionSolutionProcessToolList = new ArrayList<ProProductionSolutionProcessToolVo>();
                for (ProPrototypeMakeProcessToolVo toolVo : processToolist) {
                    ProProductionSolutionProcessToolVo productionSolutionProcessToolVo = new ProProductionSolutionProcessToolVo();
                    BeanUtil.copyProperties(toolVo, productionSolutionProcessToolVo);
                    proProductionSolutionProcessToolList.add(productionSolutionProcessToolVo);
                }
                proProductionSolutionProcessVo.setToolList(proProductionSolutionProcessToolList);
                proProductionSolutionProcessVoList.add(proProductionSolutionProcessVo);
            }
            proProductionSolutionVo.setProcessList(proProductionSolutionProcessVoList);
            proProductionSolutionVo.setUsageId(1L);
            proProductionSolutionVo.setUsageName("打样");
            // 生成生产版本
            proProductionSolutionService.insertProProductionSolution(proProductionSolutionVo);
        }


        return proPrototypeMakeMapper.updateProPrototypeMakeStatus(prototypeMakeId, prototypeMakeStatus);
    }
}
