package com.ximai.mes.pro.service.impl.productionSolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessQcindex;

import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessQcindex;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessQcindexVo;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionProcessQcindexMapper;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessQcindexService;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 生产版本工序检验项Service业务层处理
 *
 * @author generator
 * @date 2024-01-28
 */
@Service
public class ProProductionSolutionProcessQcindexServiceImpl implements IProProductionSolutionProcessQcindexService
{
    @Autowired
    private ProProductionSolutionProcessQcindexMapper proProductionSolutionProcessQcindexMapper;

    @Autowired
    private QcIndexMapper qcIndexMapper;
    /**
     * 查询生产版本工序检验项
     *
     * @param prototypeRequestProcessQcindexId 生产版本工序检验项主键
     * @return 生产版本工序检验项
     */
    @Override
    public ProProductionSolutionProcessQcindex selectProProductionSolutionProcessQcindexByPrototypeRequestProcessQcindexId(Long prototypeRequestProcessQcindexId)
    {
        return proProductionSolutionProcessQcindexMapper.selectProProductionSolutionProcessQcindexByPrototypeRequestProcessQcindexId(prototypeRequestProcessQcindexId);
    }

    /**
     * 查询生产版本工序检验项列表
     *
     * @param proProductionSolutionProcessQcindex 生产版本工序检验项
     * @return 生产版本工序检验项
     */
    @Override
    public List<ProProductionSolutionProcessQcindex> selectProProductionSolutionProcessQcindexList(ProProductionSolutionProcessQcindex proProductionSolutionProcessQcindex)
    {
        return proProductionSolutionProcessQcindexMapper.selectProProductionSolutionProcessQcindexList(proProductionSolutionProcessQcindex);
    }

    @Override
    public List<ProProductionSolutionProcessQcindexVo> selectProProductionSolutionProcessQcindexVoList(ProPrototypeRequestProcessQcindex ProPrototypeRequestProcessQcindex) {
        List<ProProductionSolutionProcessQcindexVo> rst = new ArrayList<ProProductionSolutionProcessQcindexVo>();
        ProProductionSolutionProcessQcindex qcindex = new ProProductionSolutionProcessQcindex();
        qcindex.setPrototypeSolutionId(ProPrototypeRequestProcessQcindex.getPrototypeRequestId());
        List<ProProductionSolutionProcessQcindex> list = proProductionSolutionProcessQcindexMapper.selectProProductionSolutionProcessQcindexList(qcindex);
        List<Long> ids = list.stream().map(s->s.getQcindexId()).collect(Collectors.toList());
        Map<Long, QcIndex> qcIndexMap = new HashMap<Long, QcIndex>();
        if(ids.size()>0){
            qcIndexMap.putAll(qcIndexMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getIndexId(), s->s)));
        }
        list.forEach(s->{
            ProProductionSolutionProcessQcindexVo vo = new ProProductionSolutionProcessQcindexVo();
            BeanUtil.copyProperties(s, vo);
            if(qcIndexMap.containsKey(s.getQcindexId())){
                BeanUtil.copyProperties(qcIndexMap.get(s.getQcindexId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增生产版本工序检验项
     *
     * @param proProductionSolutionProcessQcindex 生产版本工序检验项
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionProcessQcindex(ProProductionSolutionProcessQcindex proProductionSolutionProcessQcindex)
    {
        return proProductionSolutionProcessQcindexMapper.insertProProductionSolutionProcessQcindex(proProductionSolutionProcessQcindex);
    }

    /**
     * 修改生产版本工序检验项
     *
     * @param proProductionSolutionProcessQcindex 生产版本工序检验项
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionProcessQcindex(ProProductionSolutionProcessQcindex proProductionSolutionProcessQcindex)
    {
        return proProductionSolutionProcessQcindexMapper.updateProProductionSolutionProcessQcindex(proProductionSolutionProcessQcindex);
    }

    /**
     * 批量删除生产版本工序检验项
     *
     * @param prototypeRequestProcessQcindexIds 需要删除的生产版本工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessQcindexByPrototypeRequestProcessQcindexIds(Long[] prototypeRequestProcessQcindexIds)
    {
        return proProductionSolutionProcessQcindexMapper.deleteProProductionSolutionProcessQcindexByPrototypeSolutionProcessQcindexIds(prototypeRequestProcessQcindexIds);
    }

    /**
     * 删除生产版本工序检验项信息
     *
     * @param prototypeRequestProcessQcindexId 生产版本工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessQcindexByPrototypeRequestProcessQcindexId(Long prototypeRequestProcessQcindexId)
    {
        return proProductionSolutionProcessQcindexMapper.deleteProProductionSolutionProcessQcindexByPrototypeSolutionProcessQcindexId(prototypeRequestProcessQcindexId);
    }
}
