package com.ximai.mes.pro.service.impl.productionRequest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.productionRequest.*;
import com.ximai.mes.pro.domain.vo.*;
import com.ximai.mes.pro.mapper.productionRequest.*;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessQcindexService;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessToolService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestService;

/**
 * 量产申请Service业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@Service
public class ProProductionRequestServiceImpl implements IProProductionRequestService
{
    @Autowired
    private ProProductionRequestMapper proProductionRequestMapper;
    @Autowired
    private ProProductionRequestBomMapper proProductionRequestBomMapper;
    @Autowired
    private ProProductionRequestProcessMapper proProductionRequestProcessMapper;
    @Autowired
    private ProProductionRequestProcessItemMapper proProductionRequestProcessItemMapper;
    @Autowired
    private ProProductionRequestProcessToolMapper proProductionRequestProcessToolMapper;
    @Autowired
    private ProProductionRequestProcessQcindexMapper proProductionRequestProcessQcindexMapper;
    @Autowired
    private IProProductionRequestProcessToolService proProductionRequestProcessToolService;
    @Autowired
    private IProProductionRequestProcessQcindexService proProductionRequestProcessQcindexService;

    /**
     * 查询量产申请
     *
     * @param productionRequestId 量产申请主键
     * @return 量产申请
     */
    @Override
    public ProProductionRequestVo selectProProductionRequestByProductionRequestId(Long productionRequestId)
    {
        ProProductionRequestVo rst = new ProProductionRequestVo();
        ProProductionRequest proProductionRequest = proProductionRequestMapper.selectProProductionRequestByProductionRequestId(productionRequestId);
        ProProductionRequestBom proProductionRequestBom = new ProProductionRequestBom();
        proProductionRequestBom.setProductionRequestId(productionRequestId);
        List<ProProductionRequestBom> proPrototypeRequestBomList = proProductionRequestBomMapper.selectProProductionRequestBomList(proProductionRequestBom);
        ProProductionRequestProcess proProductionRequestProcess = new ProProductionRequestProcess();
        proProductionRequestProcess.setProductionRequestId(productionRequestId);
        List<ProProductionRequestProcess> proPrototypeRequestProcessList = proProductionRequestProcessMapper.selectProProductionRequestProcessList(proProductionRequestProcess);
        List<ProProductionRequestProcessVo> processVoList = new ArrayList<ProProductionRequestProcessVo>();
        for (ProProductionRequestProcess proPrototypeRequestProcess : proPrototypeRequestProcessList) {
            ProProductionRequestProcessVo temp = new ProProductionRequestProcessVo();
            // 根据记录id获取工序明细
            ProProductionRequestProcessItem requestProcessItem = new ProProductionRequestProcessItem();
            requestProcessItem.setProductionRequestProcessId(proPrototypeRequestProcess.getProductionRequestProcessId());
            List<ProProductionRequestProcessItem> processItemList = proProductionRequestProcessItemMapper.selectProProductionRequestProcessItemList(requestProcessItem);
            temp.setProcessItemList(processItemList);
            BeanUtils.copyProperties(proPrototypeRequestProcess, temp);
            processVoList.add(temp);
        }
        BeanUtils.copyProperties(proProductionRequest, rst);
        rst.setBomList(proPrototypeRequestBomList);
        rst.setProcessList(processVoList);

        //查询工装量具
        ProProductionRequestProcessTool toolQuery = new ProProductionRequestProcessTool();
        toolQuery.setProductionRequestId(proProductionRequest.getProductionRequestId());

        List<ProProductionRequestProcessToolVo> toolList = proProductionRequestProcessToolService.selectProProductionRequestProcessToolVoList(toolQuery);
        Map<Long, List<ProProductionRequestProcessToolVo>> toolMap = toolList.stream().collect(Collectors.groupingBy(s->s.getProductionRequestProcessId()));
        //查询检验项
        ProProductionRequestProcessQcindex qcindexQuery = new ProProductionRequestProcessQcindex();
        toolQuery.setProductionRequestId(proProductionRequest.getProductionRequestId());
        List<ProProductionRequestProcessQcindexVo> qcindexList = proProductionRequestProcessQcindexService.selectProProductionRequestProcessQcindexVoList(qcindexQuery);
        Map<Long, List<ProProductionRequestProcessQcindexVo>> qcindexMap = qcindexList.stream().collect(Collectors.groupingBy(s->s.getProductionRequestProcessId()));
        for (ProProductionRequestProcessVo tempProcessVo : processVoList) {
            tempProcessVo.setToolList(toolMap.getOrDefault(tempProcessVo.getProductionRequestProcessId(), new ArrayList<ProProductionRequestProcessToolVo>()));
            tempProcessVo.setQcindexList(qcindexMap.getOrDefault(tempProcessVo.getProductionRequestProcessId(),new ArrayList<ProProductionRequestProcessQcindexVo>()));

        }
        return rst;
    }

    /**
     * 查询量产申请列表
     *
     * @param proProductionRequest 量产申请
     * @return 量产申请
     */
    @Override
    public List<ProProductionRequest> selectProProductionRequestList(ProProductionRequest proProductionRequest)
    {
        return proProductionRequestMapper.selectProProductionRequestList(proProductionRequest);
    }

    @Override
    public List<ProProductionRequest> selectProProductionRequestListJoin(ProProductionRequest proProductionRequest) {
        return proProductionRequestMapper.selectProProductionRequestListJoin(proProductionRequest);
    }


    /**
     * 新增量产申请
     *
     * @param proProductionRequestVo 量产申请
     * @return 结果
     */
    @Override
    public int insertProProductionRequest(ProProductionRequestVo proProductionRequestVo)
    {
        // 获取打样申请主数据
        ProProductionRequest proProductionRequest = new ProProductionRequest();
        BeanUtils.copyProperties(proProductionRequestVo, proProductionRequest);
        proProductionRequest.setCreateTime(DateUtils.getNowDate());
        proProductionRequest.setProductionRequestStatus(0);
        proProductionRequest.setIsDisabled(0);
        int i = proProductionRequestMapper.insertProProductionRequest(proProductionRequest);
        Long prototypeRequestId = proProductionRequest.getProductionRequestId();

        // 获取打样申请BOM列表
        List<ProProductionRequestBom> bomList = proProductionRequestVo.getBomList();
        for (ProProductionRequestBom proProductionRequestBom : bomList) {
            proProductionRequestBom.setProductionRequestId(prototypeRequestId);
            proProductionRequestBomMapper.insertProProductionRequestBom(proProductionRequestBom);
        }

        // 获取打样工序
        List<ProProductionRequestProcessVo> processList = proProductionRequestVo.getProcessList();
        for (ProProductionRequestProcessVo proProductionRequestProcessVo : processList) {
            proProductionRequestProcessVo.setProductionRequestId(prototypeRequestId);
            // 保存工序
            ProProductionRequestProcess proProductionRequestProcessDb = proProductionRequestProcessVo.getPrototypeRequestProcess(proProductionRequestProcessVo);
            proProductionRequestProcessMapper.insertProProductionRequestProcess(proProductionRequestProcessDb);
            Long prototypeRequestProcessId = proProductionRequestProcessDb.getProductionRequestProcessId();
            // 获取工序物料-保存
            List<ProProductionRequestProcessItem> proProductionRequestProcessItemList = proProductionRequestProcessVo.getProcessItemList();
            for (ProProductionRequestProcessItem proProductionRequestProcessItem : proProductionRequestProcessItemList) {
                proProductionRequestProcessItem.setProductionRequestProcessId(prototypeRequestProcessId);
                proProductionRequestProcessItemMapper.insertProProductionRequestProcessItem(proProductionRequestProcessItem);
            }
            //检验项
            List<ProProductionRequestProcessQcindexVo> qcindexList = proProductionRequestProcessVo.getQcindexList();
            qcindexList.forEach(s->{
                ProProductionRequestProcessQcindex temp = new ProProductionRequestProcessQcindex();
                BeanUtil.copyProperties(s, temp);
                temp.setProductionRequestId(proProductionRequestProcessVo.getProductionRequestId());
                temp.setProductionRequestProcessId(proProductionRequestProcessDb.getProductionRequestProcessId());
                proProductionRequestProcessQcindexMapper.insertProProductionRequestProcessQcindex(temp);
            });
            //工装量具
            List<ProProductionRequestProcessToolVo> toolList = proProductionRequestProcessVo.getToolList();
            toolList.forEach(s->{
                ProProductionRequestProcessTool temp = new ProProductionRequestProcessTool();
                BeanUtil.copyProperties(s, temp);
                temp.setProductionRequestId(proProductionRequest.getProductionRequestId());
                temp.setProductionRequestProcessId(proProductionRequestProcessDb.getProductionRequestProcessId());
                proProductionRequestProcessToolMapper.insertProProductionRequestProcessTool(temp);
            });
        }
        return i;
    }

    /**
     * 修改量产申请
     *
     * @param proProductionRequestEditVo 量产申请
     * @return 结果
     */
    @Override
    public int updateProProductionRequest(ProProductionRequestEditVo proProductionRequestEditVo)
    {
        ProProductionRequest proProductionRequest = proProductionRequestMapper.selectProProductionRequestByProductionRequestId(proProductionRequestEditVo.getProductionRequestId());
        proProductionRequest.setUpdateTime(DateUtils.getNowDate());

        proProductionRequest.setRemark(proProductionRequestEditVo.getRemark());
        BeanUtils.copyProperties(proProductionRequestEditVo, proProductionRequest);
        int i = proProductionRequestMapper.updateProProductionRequest(proProductionRequest);

        // 获取打样申请BOM列表
        List<ProProductionRequestBom> bomList = proProductionRequestEditVo.getBomList();
        ProProductionRequestBom productionRequestBom = new ProProductionRequestBom();
        productionRequestBom.setProductionRequestId(proProductionRequestEditVo.getProductionRequestId());
        List<ProProductionRequestBom> dbBomList = proProductionRequestBomMapper.selectProProductionRequestBomList(productionRequestBom);
        if(bomList!=null){
            for (ProProductionRequestBom proProductionRequestBom : bomList) {
                if(proProductionRequestBom.getBomItemId()==null){
                    proProductionRequestBom.setProductionRequestId(proProductionRequest.getProductionRequestId());
                    proProductionRequestBomMapper.insertProProductionRequestBom(proProductionRequestBom);
                }else{
                    proProductionRequestBomMapper.updateProProductionRequestBom(proProductionRequestBom);
                }
            }
            dbBomList.forEach(v->{
                if(!bomList.stream().filter(v2->{
                   return v.getBomItemId().equals(v2.getBomItemId());
                }).findFirst().isPresent()){
                    proProductionRequestBomMapper.deleteProProductionRequestBomByBomItemId(v.getBomItemId());
                };
            });
        }

        // 获取打样工序
        List<ProProductionRequestProcessVo> processList = proProductionRequestEditVo.getProcessList();
        ProProductionRequestProcess productionRequestProcess = new ProProductionRequestProcess();
        productionRequestProcess.setProductionRequestId(proProductionRequestEditVo.getProductionRequestId());
        List<ProProductionRequestProcess> processListDb = proProductionRequestProcessMapper.selectProProductionRequestProcessList(productionRequestProcess);
        if(processList!=null){
            for (ProProductionRequestProcessVo proProductionRequestProcessVo : processList) {
                proProductionRequestProcessVo.setProductionRequestId(proProductionRequest.getProductionRequestId());
                // 保存工序
                ProProductionRequestProcess tempProcess = proProductionRequestProcessVo.getPrototypeRequestProcess(proProductionRequestProcessVo);
                if(tempProcess.getProductionRequestProcessId()==null) {
                    proProductionRequestProcessMapper.insertProProductionRequestProcess(tempProcess);
                }else{
                    proProductionRequestProcessMapper.updateProProductionRequestProcess(tempProcess);
                }
                Long prototypeRequestProcessId = tempProcess.getProductionRequestProcessId();
                // 获取工序物料-保存
                List<ProProductionRequestProcessItem> proProductionRequestProcessItemList = proProductionRequestProcessVo.getProcessItemList();
                ProProductionRequestProcessItem proProductionRequestProcessItemQuery = new ProProductionRequestProcessItem();
                proProductionRequestProcessItemQuery.setProductionRequestProcessId(proProductionRequestProcessVo.getProductionRequestProcessId());
                List<ProProductionRequestProcessItem> proProductionRequestProcessItemListDb = proProductionRequestProcessItemMapper.selectProProductionRequestProcessItemList(proProductionRequestProcessItemQuery);
                for (ProProductionRequestProcessItem proProductionRequestProcessItem : proProductionRequestProcessItemList) {
                    proProductionRequestProcessItem.setProductionRequestProcessId(prototypeRequestProcessId);
                    if(proProductionRequestProcessItem.getProductionRequestProcessItemId()==null) {
                        proProductionRequestProcessItemMapper.insertProProductionRequestProcessItem(proProductionRequestProcessItem);
                    }else{
                        proProductionRequestProcessItemMapper.updateProProductionRequestProcessItem(proProductionRequestProcessItem);
                    }
                }
                proProductionRequestProcessItemListDb.forEach(v->{
                    if(!proProductionRequestProcessItemList.stream().filter(v2->{
                        return v.getProductionRequestProcessItemId().equals(v2.getProductionRequestProcessItemId());
                    }).findFirst().isPresent()){
                        proProductionRequestProcessMapper.deleteProProductionRequestProcessByProductionRequestProcessId(v.getProductionRequestProcessItemId());
                    };
                });

                //检验项保存、删除
                List<ProProductionRequestProcessQcindexVo> proProductionRequestProcessQcindexList = proProductionRequestProcessVo.getQcindexList();
                ProProductionRequestProcessQcindex proProductionRequestProcessQcindexQuery = new ProProductionRequestProcessQcindex();
                proProductionRequestProcessQcindexQuery.setProductionRequestProcessId(proProductionRequestProcessVo.getProductionRequestProcessId());
                List<ProProductionRequestProcessQcindex> proProductionRequestProcessQcindexListDb = proProductionRequestProcessQcindexMapper.selectProProductionRequestProcessQcindexList(proProductionRequestProcessQcindexQuery);
                for (ProProductionRequestProcessQcindexVo proProductionRequestProcessQcindexVo : proProductionRequestProcessQcindexList) {
                    ProProductionRequestProcessQcindex proProductionRequestProcessQcindex = new ProProductionRequestProcessQcindex();
                    BeanUtil.copyProperties(proProductionRequestProcessQcindexVo, proProductionRequestProcessQcindex);
                    proProductionRequestProcessQcindex.setProductionRequestId(proProductionRequestProcessVo.getProductionRequestId());
                    proProductionRequestProcessQcindex.setProductionRequestProcessId(prototypeRequestProcessId);
                    if(proProductionRequestProcessQcindex.getProductionRequestProcessQcindexId()==null) {
                        proProductionRequestProcessQcindexMapper.insertProProductionRequestProcessQcindex(proProductionRequestProcessQcindex);
                    }else{
                        proProductionRequestProcessQcindexMapper.updateProProductionRequestProcessQcindex(proProductionRequestProcessQcindex);
                    }
                }
                proProductionRequestProcessQcindexListDb.forEach(v->{
                    if(!proProductionRequestProcessQcindexList.stream().filter(v2->{
                        return v.getProductionRequestProcessQcindexId().equals(v2.getProductionRequestProcessQcindexId());
                    }).findFirst().isPresent()){
                        proProductionRequestProcessQcindexMapper.deleteProProductionRequestProcessQcindexByProductionRequestProcessQcindexId(v.getProductionRequestProcessQcindexId());
                    };
                });
                //工装
                List<ProProductionRequestProcessToolVo> proProductionRequestProcessToolList = proProductionRequestProcessVo.getToolList();
                ProProductionRequestProcessTool proProductionRequestProcessToolQuery = new ProProductionRequestProcessTool();
                proProductionRequestProcessToolQuery.setProductionRequestProcessId(prototypeRequestProcessId);
                List<ProProductionRequestProcessTool> proProductionRequestProcessToolListDb = proProductionRequestProcessToolMapper.selectProProductionRequestProcessToolList(proProductionRequestProcessToolQuery);
                for (ProProductionRequestProcessToolVo proProductionRequestProcessToolVo : proProductionRequestProcessToolList) {
                    ProProductionRequestProcessTool proProductionRequestProcessTool = new ProProductionRequestProcessTool();
                    BeanUtil.copyProperties(proProductionRequestProcessToolVo, proProductionRequestProcessTool);
                    proProductionRequestProcessTool.setProductionRequestProcessId(prototypeRequestProcessId);
                    proProductionRequestProcessTool.setProductionRequestId(proProductionRequestProcessVo.getProductionRequestId());
                    if(proProductionRequestProcessTool.getProductionRequestProcessToolId()==null) {
                        proProductionRequestProcessToolMapper.insertProProductionRequestProcessTool(proProductionRequestProcessTool);
                    }else{
                        proProductionRequestProcessToolMapper.updateProProductionRequestProcessTool(proProductionRequestProcessTool);
                    }
                }
                proProductionRequestProcessToolListDb.forEach(v->{
                    if(!proProductionRequestProcessToolList.stream().filter(v2->{
                        return v.getProductionRequestProcessToolId().equals(v2.getProductionRequestProcessToolId());
                    }).findFirst().isPresent()){
                        proProductionRequestProcessToolMapper.deleteProProductionRequestProcessToolByProductionRequestProcessToolId(v.getProductionRequestProcessToolId());
                    };
                });
            }
            processListDb.forEach(v->{
                Optional<ProProductionRequestProcessVo> optionalProProductionRequestProcessVo = processList.stream().filter(v2->{
                    return v.getProductionRequestProcessId().equals(v2.getProductionRequestProcessId());
                }).findFirst();
                if(!optionalProProductionRequestProcessVo.isPresent()){
                    proProductionRequestProcessMapper.deleteProProductionRequestProcessByProductionRequestProcessId(v.getProductionRequestProcessId());
                };
            });
        }

        return i;
    }

    /**
     * 批量删除量产申请
     *
     * @param productionRequestIds 需要删除的量产申请主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestByProductionRequestIds(Long[] productionRequestIds)
    {
        int i = 0;
        for(Long l : productionRequestIds) {
            i += this.deleteProProductionRequestByProductionRequestId(l);
        }
        return i;
    }

    /**
     * 删除量产申请信息
     *
     * @param productionRequestId 量产申请主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestByProductionRequestId(Long productionRequestId)
    {
        //删除BOM
        proProductionRequestBomMapper.deleteProProductionRequestBomByProductionRequestId(productionRequestId);
        //删除工序
        proProductionRequestProcessMapper.deleteProProductionRequestProcessByProductionRequestId(productionRequestId);
        proProductionRequestProcessItemMapper.deleteProProductionRequestProcessItemByProductionRequestId(productionRequestId);
        return proProductionRequestMapper.deleteProProductionRequestByProductionRequestId(productionRequestId);
    }

    @Override
    public int updateProProductionRequestStatus(ProProductionRequest proProductionRequest) {
        return proProductionRequestMapper.updateProProductionRequestStatus(proProductionRequest.getProductionRequestId(), proProductionRequest.getProductionRequestStatus());
    }


}
