package com.ximai.mes.pro.service.impl.productionRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.vo.ProProductionRequestProcessToolVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionRequest.ProProductionRequestProcessToolMapper;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcessTool;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessToolService;

/**
 * 量产申请工序工装夹具Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProProductionRequestProcessToolServiceImpl implements IProProductionRequestProcessToolService
{
    @Autowired
    private ProProductionRequestProcessToolMapper proProductionRequestProcessToolMapper;
    @Autowired
    private MdItemMapper mdItemMapper;
    /**
     * 查询量产申请工序工装夹具
     *
     * @param productionRequestProcessToolId 量产申请工序工装夹具主键
     * @return 量产申请工序工装夹具
     */
    @Override
    public ProProductionRequestProcessTool selectProProductionRequestProcessToolByProductionRequestProcessToolId(Long productionRequestProcessToolId)
    {
        return proProductionRequestProcessToolMapper.selectProProductionRequestProcessToolByProductionRequestProcessToolId(productionRequestProcessToolId);
    }

    /**
     * 查询量产申请工序工装夹具列表
     *
     * @param proProductionRequestProcessTool 量产申请工序工装夹具
     * @return 量产申请工序工装夹具
     */
    @Override
    public List<ProProductionRequestProcessTool> selectProProductionRequestProcessToolList(ProProductionRequestProcessTool proProductionRequestProcessTool)
    {
        return proProductionRequestProcessToolMapper.selectProProductionRequestProcessToolList(proProductionRequestProcessTool);
    }

    @Override
    public List<ProProductionRequestProcessToolVo> selectProProductionRequestProcessToolVoList(ProProductionRequestProcessTool proProductionRequestProcessTool)
    {
        List<ProProductionRequestProcessToolVo> rst = new ArrayList<ProProductionRequestProcessToolVo>();
        ProProductionRequestProcessTool query = new ProProductionRequestProcessTool();
        query.setProductionRequestId(proProductionRequestProcessTool.getProductionRequestId());
        List<ProProductionRequestProcessTool> list = proProductionRequestProcessToolMapper.selectProProductionRequestProcessToolList(query);
        List<Long> ids = list.stream().map(s->s.getToolId()).collect(Collectors.toList());
        Map<Long, MdItem> toolMap = new HashMap<Long, MdItem>();
        if(ids.size()>0){
            toolMap.putAll(mdItemMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getItemId(), s->s)));
        }
        list.forEach(s->{
            ProProductionRequestProcessToolVo vo = new ProProductionRequestProcessToolVo();
            BeanUtil.copyProperties(s, vo);
            if(toolMap.containsKey(s.getToolId())){
                BeanUtil.copyProperties(toolMap.get(s.getToolId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增量产申请工序工装夹具
     *
     * @param proProductionRequestProcessTool 量产申请工序工装夹具
     * @return 结果
     */
    @Override
    public int insertProProductionRequestProcessTool(ProProductionRequestProcessTool proProductionRequestProcessTool)
    {
        return proProductionRequestProcessToolMapper.insertProProductionRequestProcessTool(proProductionRequestProcessTool);
    }

    /**
     * 修改量产申请工序工装夹具
     *
     * @param proProductionRequestProcessTool 量产申请工序工装夹具
     * @return 结果
     */
    @Override
    public int updateProProductionRequestProcessTool(ProProductionRequestProcessTool proProductionRequestProcessTool)
    {
        return proProductionRequestProcessToolMapper.updateProProductionRequestProcessTool(proProductionRequestProcessTool);
    }

    /**
     * 批量删除量产申请工序工装夹具
     *
     * @param productionRequestProcessToolIds 需要删除的量产申请工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessToolByProductionRequestProcessToolIds(Long[] productionRequestProcessToolIds)
    {
        return proProductionRequestProcessToolMapper.deleteProProductionRequestProcessToolByProductionRequestProcessToolIds(productionRequestProcessToolIds);
    }

    /**
     * 删除量产申请工序工装夹具信息
     *
     * @param productionRequestProcessToolId 量产申请工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessToolByProductionRequestProcessToolId(Long productionRequestProcessToolId)
    {
        return proProductionRequestProcessToolMapper.deleteProProductionRequestProcessToolByProductionRequestProcessToolId(productionRequestProcessToolId);
    }
}
