package com.ximai.mes.pro.service.impl.productionRequest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionRequest.ProProductionRequestProcessMapper;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcess;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessService;

/**
 * 量产申请工序Service业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@Service
public class ProProductionRequestProcessServiceImpl implements IProProductionRequestProcessService
{
    @Autowired
    private ProProductionRequestProcessMapper proProductionRequestProcessMapper;

    /**
     * 查询量产申请工序
     *
     * @param productionRequestProcessId 量产申请工序主键
     * @return 量产申请工序
     */
    @Override
    public ProProductionRequestProcess selectProProductionRequestProcessByProductionRequestProcessId(Long productionRequestProcessId)
    {
        return proProductionRequestProcessMapper.selectProProductionRequestProcessByProductionRequestProcessId(productionRequestProcessId);
    }

    /**
     * 查询量产申请工序列表
     *
     * @param proProductionRequestProcess 量产申请工序
     * @return 量产申请工序
     */
    @Override
    public List<ProProductionRequestProcess> selectProProductionRequestProcessList(ProProductionRequestProcess proProductionRequestProcess)
    {
        return proProductionRequestProcessMapper.selectProProductionRequestProcessList(proProductionRequestProcess);
    }

    /**
     * 新增量产申请工序
     *
     * @param proProductionRequestProcess 量产申请工序
     * @return 结果
     */
    @Override
    public int insertProProductionRequestProcess(ProProductionRequestProcess proProductionRequestProcess)
    {
        return proProductionRequestProcessMapper.insertProProductionRequestProcess(proProductionRequestProcess);
    }

    /**
     * 修改量产申请工序
     *
     * @param proProductionRequestProcess 量产申请工序
     * @return 结果
     */
    @Override
    public int updateProProductionRequestProcess(ProProductionRequestProcess proProductionRequestProcess)
    {
        return proProductionRequestProcessMapper.updateProProductionRequestProcess(proProductionRequestProcess);
    }

    /**
     * 批量删除量产申请工序
     *
     * @param productionRequestProcessIds 需要删除的量产申请工序主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessByProductionRequestProcessIds(Long[] productionRequestProcessIds)
    {
        return proProductionRequestProcessMapper.deleteProProductionRequestProcessByProductionRequestProcessIds(productionRequestProcessIds);
    }

    /**
     * 删除量产申请工序信息
     *
     * @param productionRequestProcessId 量产申请工序主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessByProductionRequestProcessId(Long productionRequestProcessId)
    {
        return proProductionRequestProcessMapper.deleteProProductionRequestProcessByProductionRequestProcessId(productionRequestProcessId);
    }
}
