package com.ximai.mes.pro.service.impl.productionRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.domain.vo.ProProductionRequestProcessQcindexVo;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionRequest.ProProductionRequestProcessQcindexMapper;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcessQcindex;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessQcindexService;

/**
 * 量产申请工序检验项Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProProductionRequestProcessQcindexServiceImpl implements IProProductionRequestProcessQcindexService
{
    @Autowired
    private ProProductionRequestProcessQcindexMapper proProductionRequestProcessQcindexMapper;
    @Autowired
    private QcIndexMapper qcIndexMapper;

    /**
     * 查询量产申请工序检验项
     *
     * @param productionRequestProcessQcindexId 量产申请工序检验项主键
     * @return 量产申请工序检验项
     */
    @Override
    public ProProductionRequestProcessQcindex selectProProductionRequestProcessQcindexByProductionRequestProcessQcindexId(Long productionRequestProcessQcindexId)
    {
        return proProductionRequestProcessQcindexMapper.selectProProductionRequestProcessQcindexByProductionRequestProcessQcindexId(productionRequestProcessQcindexId);
    }

    /**
     * 查询量产申请工序检验项列表
     *
     * @param proProductionRequestProcessQcindex 量产申请工序检验项
     * @return 量产申请工序检验项
     */
    @Override
    public List<ProProductionRequestProcessQcindex> selectProProductionRequestProcessQcindexList(ProProductionRequestProcessQcindex proProductionRequestProcessQcindex)
    {
        return proProductionRequestProcessQcindexMapper.selectProProductionRequestProcessQcindexList(proProductionRequestProcessQcindex);
    }

    @Override
    public List<ProProductionRequestProcessQcindexVo> selectProProductionRequestProcessQcindexVoList(ProProductionRequestProcessQcindex proProductionRequestProcessQcindex)
    {
        List<ProProductionRequestProcessQcindexVo> rst = new ArrayList<ProProductionRequestProcessQcindexVo>();
        ProProductionRequestProcessQcindex query = new ProProductionRequestProcessQcindex();
        query.setProductionRequestId(proProductionRequestProcessQcindex.getProductionRequestId());
        List<ProProductionRequestProcessQcindex> list = proProductionRequestProcessQcindexMapper.selectProProductionRequestProcessQcindexList(query);
        List<Long> ids = list.stream().map(s->s.getQcindexId()).collect(Collectors.toList());
        Map<Long, QcIndex> qcIndexMap = new HashMap<Long, QcIndex>();
        if(ids.size()>0){
            qcIndexMap.putAll(qcIndexMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getIndexId(), s->s)));
        }
        list.forEach(s->{
            ProProductionRequestProcessQcindexVo vo = new ProProductionRequestProcessQcindexVo();
            BeanUtil.copyProperties(s, vo);
            if(qcIndexMap.containsKey(s.getQcindexId())){
                BeanUtil.copyProperties(qcIndexMap.get(s.getQcindexId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增量产申请工序检验项
     *
     * @param proProductionRequestProcessQcindex 量产申请工序检验项
     * @return 结果
     */
    @Override
    public int insertProProductionRequestProcessQcindex(ProProductionRequestProcessQcindex proProductionRequestProcessQcindex)
    {
        return proProductionRequestProcessQcindexMapper.insertProProductionRequestProcessQcindex(proProductionRequestProcessQcindex);
    }

    /**
     * 修改量产申请工序检验项
     *
     * @param proProductionRequestProcessQcindex 量产申请工序检验项
     * @return 结果
     */
    @Override
    public int updateProProductionRequestProcessQcindex(ProProductionRequestProcessQcindex proProductionRequestProcessQcindex)
    {
        return proProductionRequestProcessQcindexMapper.updateProProductionRequestProcessQcindex(proProductionRequestProcessQcindex);
    }

    /**
     * 批量删除量产申请工序检验项
     *
     * @param productionRequestProcessQcindexIds 需要删除的量产申请工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessQcindexByProductionRequestProcessQcindexIds(Long[] productionRequestProcessQcindexIds)
    {
        return proProductionRequestProcessQcindexMapper.deleteProProductionRequestProcessQcindexByProductionRequestProcessQcindexIds(productionRequestProcessQcindexIds);
    }

    /**
     * 删除量产申请工序检验项信息
     *
     * @param productionRequestProcessQcindexId 量产申请工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessQcindexByProductionRequestProcessQcindexId(Long productionRequestProcessQcindexId)
    {
        return proProductionRequestProcessQcindexMapper.deleteProProductionRequestProcessQcindexByProductionRequestProcessQcindexId(productionRequestProcessQcindexId);
    }
}
