package com.ximai.mes.pro.service.impl;

import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProUsage;
import com.ximai.mes.pro.mapper.ProUsageMapper;
import com.ximai.mes.pro.service.IProUsageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/15
 * description:
 */
@Service
public class ProUsageServiceImpl implements IProUsageService {
    @Autowired
    private ProUsageMapper proUsageMapper;

    /**
     * 条件查询用途列表
     *
     * @param proUsage 查询条件
     * @return
     */
    @Override
    public List<ProUsage> selectProUsageList(ProUsage proUsage) {
        return proUsageMapper.selectProUsageList(proUsage);
    }

    @Override
    public ProUsage selectProUsageByUsageId(Long usageId) {

        return proUsageMapper.selectProUsageByUsageId(usageId);
    }

    /**
     * 查询编码是否唯一
     *
     * @param proUsage
     * @return
     */
    @Override
    public String checkUsageCodeUnique(ProUsage proUsage) {
        ProUsage usage = proUsageMapper.checkUsageCodeUnique(proUsage);
        Long usageId = proUsage.getUsageId() == null ? -1L : proUsage.getUsageId();
        if (StringUtils.isNotNull(usage) && usage.getUsageId().longValue() != usageId) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     *  查询用途名称是否唯一
     * @param proUsage
     * @return
     */
    @Override
    public String checkUsageNameUnique(ProUsage proUsage) {
        ProUsage usage = proUsageMapper.checkUsageNameUnique(proUsage);
        Long usageId = proUsage.getUsageId()==null?-1L:proUsage.getUsageId();
        if(StringUtils.isNotNull(usage) && usage.getUsageId().longValue() != usageId){
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     *  新增用途
     * @param proUsage
     * @return
     */
    @Override
    public int insertProUsage(ProUsage proUsage) {
        proUsage.setCreateTime(DateUtils.getNowDate());
        return proUsageMapper.insertProUsage(proUsage);
    }

    @Override
    public int updateProProcess(ProUsage proUsage) {
        proUsage.setUpdateTime(DateUtils.getNowDate());
        return proUsageMapper.updateProUsage(proUsage);
    }

    @Override
    public int deleteProUsageByUsageIds(Long[] usageIds) {
        return proUsageMapper.deleteProUsageByUsageIds(usageIds);
    }
}
