package com.ximai.mes.pro.service;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleUpdate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleDto;

/**
 * 产品二维码规则Service接口
 * 
 * @author generator
 * @date 2024-08-31
 */
public interface IProProductQrcodeRuleService 
{
    /**
     * 查询产品二维码规则
     *
     * @param ruleId 产品二维码规则主键
     * @return 产品二维码规则
     */
    public ProProductQrcodeRuleDto selectProProductQrcodeRuleDtoByRuleId(Long ruleId);

    /**
     * 查询产品二维码规则
     *
     * @param ruleId 产品二维码规则主键
     * @return 产品二维码规则
     */
    public ProProductQrcodeRule selectProProductQrcodeRuleByRuleId(Long ruleId);

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRule 产品二维码规则
     * @return 产品二维码规则集合
     */
    public List<ProProductQrcodeRuleDto> selectProProductQrcodeRuleList(ProProductQrcodeRule proProductQrcodeRule);

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRuleQuery 产品二维码规则
     * @return 产品二维码规则集合
     */
    public List<ProProductQrcodeRule> selectProProductQrcodeRuleList(QueryWrapper<ProProductQrcodeRule> proProductQrcodeRuleQuery);

    /**
     * 查询产品最新二维码规则列表
     *
     * @param itemId 产品ID
     * @param clientCode 客户编号
     * @return 产品二维码规则集合
     */
    public ProProductQrcodeRule selectProProductQrcodeRuleNewest(Long itemId, String clientCode);

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRuleQuery 产品二维码规则
     * @return 产品二维码规则集合
     */
    public List<ProProductQrcodeRuleDto> selectProProductQrcodeRuleDtoList(QueryWrapper<ProProductQrcodeRule> proProductQrcodeRuleQuery);

    /**
     * 新增产品二维码规则
     * 
     * @param proProductQrcodeRule 产品二维码规则
     * @return 结果
     */
    public int insertProProductQrcodeRule(ProProductQrcodeRuleCreate proProductQrcodeRule);

    /**
     * 修改产品二维码规则
     * 
     * @param proProductQrcodeRule 产品二维码规则
     * @return 结果
     */
    public int updateProProductQrcodeRule(ProProductQrcodeRuleUpdate proProductQrcodeRule);

    /**
     * 批量删除产品二维码规则
     * 
     * @param ruleIds 需要删除的产品二维码规则主键集合
     * @return 结果
     */
    public int deleteProProductQrcodeRuleByRuleIds(Long[] ruleIds);

    /**
     * 删除产品二维码规则信息
     * 
     * @param ruleId 产品二维码规则主键
     * @return 结果
     */
    public int deleteProProductQrcodeRuleByRuleId(Long ruleId);

    /**
     * 获取产品序列编码
     * @param rule
     * @return
     */
    public List<String> buildQrcode(ProProductQrcodeRule rule, Integer quantity);
}
