package com.ximai.mes.pro.mapper.prototypeRequest;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequest;
import com.ximai.mes.pro.domain.vo.ProPrototypeRequestVo;
import org.apache.ibatis.annotations.Param;

/**
 * 打样申请Mapper接口
 *
 * @author zht
 * @date 2024-01-18
 */
public interface ProPrototypeRequestMapper extends BaseMapper<ProPrototypeRequest>
{
    /**
     * 查询打样申请
     *
     * @param prototypeRequestId 打样申请主键
     * @return 打样申请
     */
    public ProPrototypeRequestVo selectProPrototypeRequestByPrototypeRequestId(Long prototypeRequestId);

    /**
     * 查询打样申请列表
     *
     * @param proPrototypeRequest 打样申请
     * @return 打样申请集合
     */
    public List<ProPrototypeRequest> selectProPrototypeRequestList(ProPrototypeRequest proPrototypeRequest);

    /**
     * 新增打样申请
     *
     * @param proPrototypeRequest 打样申请
     * @return 结果
     */
    public int insertProPrototypeRequest(ProPrototypeRequest proPrototypeRequest);

    /**
     * 修改打样申请
     *
     * @param proPrototypeRequest 打样申请
     * @return 结果
     */
    public int updateProPrototypeRequest(ProPrototypeRequest proPrototypeRequest);

    /**
     * 删除打样申请
     *
     * @param prototypeRequestId 打样申请主键
     * @return 结果
     */
    public int deleteProPrototypeRequestByPrototypeRequestId(Long prototypeRequestId);

    /**
     * 批量删除打样申请
     *
     * @param prototypeRequestIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeRequestByPrototypeRequestIds(Long[] prototypeRequestIds);

    int updateProPrototypeRequestStatus(@Param("prototypeRequestId") Long prototypeRequestId, @Param("prototypeRequestStatus") int prototypeRequestStatus);
}
