package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 生产工单尺码Mapper接口
 *
 * @author zht
 * @date 2024-02-29
 */
public interface ProWorkOrderSoSizeItemMapper extends BaseMapper<ProWorkOrderSoSizeItem> {
    /**
     * 查询生产工单尺码
     *
     * @param workorderSoSizeItemId 生产工单尺码主键
     * @return 生产工单尺码
     */
    ProWorkOrderSoSizeItem selectProWorkOrderSoSizeItemByWorkorderSoSizeItemId(Long workorderSoSizeItemId);

    /**
     * 查询生产工单尺码列表
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 生产工单尺码集合
     */
    List<ProWorkOrderSoSizeItem> selectProWorkOrderSoSizeItemList(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);

    /**
     * 新增生产工单尺码
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 结果
     */
    int insertProWorkOrderSoSizeItem(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);

    /**
     * 修改生产工单尺码
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 结果
     */
    int updateProWorkOrderSoSizeItem(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);

    /**
     * 删除生产工单尺码
     *
     * @param workorderSoSizeItemId 生产工单尺码主键
     * @return 结果
     */
    int deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemId(Long workorderSoSizeItemId);

    /**
     * 批量删除生产工单尺码
     *
     * @param workorderSoSizeItemIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemIds(Long[] workorderSoSizeItemIds);

    List<ProWorkOrderSoSizeItem> selectProWorkOrderSoSizeItemByWorkorderId(Long workorderId);

    /**
     * 查询生产工单尺码列表
     *
     * @param query 生产工单尺码
     * @return 生产工单尺码集合
     */
    @Select(value = "select * from pro_work_order_so_size_item ${ew.customSqlSegment}")
    List<Map<String, Object>> selectProWorkOrderSoSizeItemListMap(@Param("ew") QueryWrapper<ProWorkOrderSoSizeItem> query);


    @Select(value = "select * from pro_work_order_so_size_item ${ew.customSqlSegment}")
    List<ProWorkOrderSoSizeItem> selectListByQw(@Param("ew") QueryWrapper<ProWorkOrderSoSizeItem> query);

    @Delete(value = "delete from pro_work_order_so_size_item  ${ew.customSqlSegment}")
    void deleteProWorkOrderSoSizeItem(@Param("ew") QueryWrapper<ProWorkOrderSoSizeItem> queryWrapper);

}
