package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProWorkOrderArrangeRule;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 编排单对照表Mapper接口
 *
 * @author generator
 * @date 2024-03-14
 */
public interface ProWorkOrderArrangeRuleMapper extends BaseMapper<ProWorkOrderArrangeRule> {
    /**
     * 查询编排单对照表
     *
     * @param arrangeRuleId 编排单对照表主键
     * @return 编排单对照表
     */
    ProWorkOrderArrangeRule selectProWorkOrderArrangeRuleByArrangeRuleId(Long arrangeRuleId);

    /**
     * 查询编排单对照表列表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 编排单对照表集合
     */
    List<ProWorkOrderArrangeRule> selectProWorkOrderArrangeRuleList(ProWorkOrderArrangeRule proWorkOrderArrangeRule);

    /**
     * 新增编排单对照表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 结果
     */
    int insertProWorkOrderArrangeRule(ProWorkOrderArrangeRule proWorkOrderArrangeRule);

    /**
     * 修改编排单对照表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 结果
     */
    int updateProWorkOrderArrangeRule(ProWorkOrderArrangeRule proWorkOrderArrangeRule);

    /**
     * 删除编排单对照表
     *
     * @param arrangeRuleId 编排单对照表主键
     * @return 结果
     */
    int deleteProWorkOrderArrangeRuleByArrangeRuleId(Long arrangeRuleId);

    /**
     * 批量删除编排单对照表
     *
     * @param arrangeRuleIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderArrangeRuleByArrangeRuleIds(Long[] arrangeRuleIds);

    /**
     * 查询编排单对照表列表
     *
     * @param query 编排单对照表
     * @return 编排单对照表集合
     */
    @Select(value = "select * from pro_work_order_arrange_rule ${ew.customSqlSegment}")
    List<Map<String, Object>> selectProWorkOrderArrangeRuleMap(@Param("ew") QueryWrapper<ProWorkOrderArrangeRule> query);
}
