package com.ximai.mes.pro.mapper;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProScheduleSetupRuleVal;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

/**
 * 排产换型属性值信息Mapper接口
 *
 * @author generator
 * @date 2024-04-01
 */
public interface ProScheduleSetupRuleValMapper extends BaseMapper<ProScheduleSetupRuleVal>
{
    /**
     * 查询排产换型属性值信息
     *
     * @param ruleValId 排产换型属性值信息主键
     * @return 排产换型属性值信息
     */
    public ProScheduleSetupRuleVal selectProScheduleSetupRuleValByRuleValId(Long ruleValId);

    /**
     * 查询排产换型属性值信息列表
     *
     * @param proScheduleSetupRuleVal 排产换型属性值信息
     * @return 排产换型属性值信息集合
     */
    public List<ProScheduleSetupRuleVal> selectProScheduleSetupRuleValList(ProScheduleSetupRuleVal proScheduleSetupRuleVal);

    /**
     * 查询排产换型规则属性唯一值列表
     *
     * @param query 排产换型属性值信息
     * @return 排产换型属性值信息集合
     */
    @Select(value = "select * from pro_schedule_setup_rule_val ${ew.customSqlSegment}")
    List<Map<String, Object>> selectProScheduleSetupRuleVal(@Param("ew") QueryWrapper<ProScheduleSetupRuleVal> query);

    /**
     * 新增排产换型属性值信息
     *
     * @param proScheduleSetupRuleVal 排产换型属性值信息
     * @return 结果
     */
    public int insertProScheduleSetupRuleVal(ProScheduleSetupRuleVal proScheduleSetupRuleVal);

    /**
     * 修改排产换型属性值信息
     *
     * @param proScheduleSetupRuleVal 排产换型属性值信息
     * @return 结果
     */
    public int updateProScheduleSetupRuleVal(ProScheduleSetupRuleVal proScheduleSetupRuleVal);

    /**
     * 删除排产换型属性值信息
     *
     * @param ruleValId 排产换型属性值信息主键
     * @return 结果
     */
    public int deleteProScheduleSetupRuleValByRuleValId(Long ruleValId);

    /**
     * 批量删除排产换型属性值信息
     *
     * @param ruleValIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProScheduleSetupRuleValByRuleValIds(Long[] ruleValIds);

    /**
     * 根据工单删除排产换型属性值信息
     *
     * @param workorderId 工单编排规则属性唯一值
     * @return 工单编排规则属性唯一值集合
     */
    @Update(value = "delete from pro_schedule_setup_rule_val where workorder_id = #{workorderId}")
    void deleteByWorkorderId(@Param("workorderId") Long workorderId);


}
