package com.ximai.mes.pro.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProMaterialReturn;
import com.ximai.mes.pro.domain.vo.ProMaterialReturnVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 退料申请Mapper接口
 *
 * @author generator
 * @date 2024-02-22
 */
public interface ProMaterialReturnMapper extends BaseMapper<ProMaterialReturn> {
    /**
     * 查询退料申请
     *
     * @param materialReturnId 退料申请主键
     * @return 退料申请
     */
    ProMaterialReturn selectProMaterialReturnByMaterialReturnId(Long materialReturnId);

    /**
     * 查询退料申请列表
     *
     * @param proMaterialReturn 退料申请
     * @return 退料申请集合
     */
    List<ProMaterialReturn> selectProMaterialReturnList(ProMaterialReturn proMaterialReturn);




    /**
     * 新增退料申请
     *
     * @param proMaterialReturn 退料申请
     * @return 结果
     */
    int insertProMaterialReturn(ProMaterialReturn proMaterialReturn);

    /**
     * 修改退料申请
     *
     * @param proMaterialReturn 退料申请
     * @return 结果
     */
    int updateProMaterialReturn(ProMaterialReturn proMaterialReturn);

    /**
     * 删除退料申请
     *
     * @param materialReturnId 退料申请主键
     * @return 结果
     */
    int deleteProMaterialReturnByMaterialReturnId(Long materialReturnId);

    /**
     * 批量删除退料申请
     *
     * @param materialReturnIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProMaterialReturnByMaterialReturnIds(Long[] materialReturnIds);

    @Select("select * from pro_material_return ${ew.customSqlSegment}")
    List<ProMaterialReturn> selectProMaterialReturnList2(@Param("ew") QueryWrapper<ProMaterialReturn> query);

        @Select(" select p.material_return_id, p.apply_no, p.return_reason,p.item_id, p.task_id,p.issue_line_id,p.workorder_id,\n" +
            "        p.workorder_code, p.task_workunit_id, p.back_num, p.wind_case, p.is_qualified, p.batch_no, p.pack_no,\n" +
            "        p.remark, p.attr1, p.attr2, p.attr3, p.attr4, p.create_by, p.create_time, p.update_by,\n" +
            "        p.update_time, mw.workunit_code, mw.workunit_name, mw.workstation_code, mn.workstation_name,\n" +
            "\t\t\t\tmn.workshop_code, mn.workshop_name, m.sap_item_code, m.item_name, m.item_code\n" +
            "        from pro_material_return p\n" +
            "                left join pro_task_workunit ptw on p.task_workunit_id = ptw.task_workunit_id\n" +
            "                left join md_workunit mw on ptw.workunit_id = mw.workunit_id\n" +
            "\t\t\t\t\t\t\t\tleft join md_workstation mn on mn.workstation_code = mw.workstation_code\n" +
            "                 left join md_item m on p.item_id = m.item_id ${ew.customSqlSegment}")
    List<ProMaterialReturnVo> selectProMaterialReturnList3(@Param("ew") QueryWrapper<ProMaterialReturn> query);

    @Select("select  *from pro_material_return where apply_no=#{applyNo} and workorder_code=#{workorderCode}")
    List<ProMaterialReturn> selectProMaterialReturnByApplyNoOrWorkorder(@Param("applyNo") String applyNo,@Param("workorderCode") String workorderCode);
}
