package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.vo.ProFeedbackVo;
import com.ximai.mes.pro.domain.vo.ProProcessTaskVo;
import com.ximai.mes.pro.dto.ProFeedbackDto;
import com.ximai.mes.report.request.FeedbackRequest;
import com.ximai.mes.report.response.*;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.security.core.parameters.P;

import java.util.List;

/**
 * 生产报工记录Mapper接口
 *
 * @date 2022-07-10
 */
public interface ProFeedbackMapper {
    /**
     * 查询生产报工记录
     *
     * @param recordId 生产报工记录主键
     * @return 生产报工记录
     */
    ProFeedback selectProFeedbackByRecordId(Long recordId);

    /**
     * 查询生产报工记录列表
     *
     * @param proFeedback 生产报工记录
     * @return 生产报工记录集合
     */
    List<ProFeedback> selectProFeedbackList(ProFeedback proFeedback);

    /**
     * 查询生产报工记录列表
     *
     * @param query 生产报工记录
     * @return 生产报工记录集合
     */
    @Select(value = "select * from pro_feedback f\n" +
            "${ew.customSqlSegment}")
    List<ProFeedback> selectListByQw(@Param("ew") QueryWrapper<ProFeedback> query);

    /**
     * 查询生产报工记录列表
     *
     * @param query 生产报工记录
     * @return 生产报工记录集合
     */
    @Select(value = "SELECT\n" +
            "\tf.*,\n" +
            "\twu.workunit_name,\n" +
            "\twu.workunit_id,\n" +
            "\t workorder.order_code,\n" +
            "\t workorder.order_serial,\n" +
            "\t workorder.customer_drawing_no,\n" +
            "\tit.sap_item_code,ta.arrange_code \n" +
            "FROM\n" +
            "\tpro_feedback f\n" +
            "\tLEFT JOIN pro_task_workunit tw ON tw.task_workunit_id = f.task_workunit_id\n" +
            "\tLEFT JOIN md_workunit wu ON wu.workunit_id = tw.workunit_id\n" +
            "\tLEFT JOIN md_item it ON it.item_id = f.item_id \n" +
            "\tLEFT JOIN pro_task ta  ON ta.task_id = f.task_id \n" +
            "\tLEFT JOIN pro_workorder workorder  ON workorder.workorder_id = f.workorder_id \n" +
            "${ew.customSqlSegment}")
    List<ProFeedbackVo> queryProFeedbackListJoinTaskWorkUnit(@Param("ew") QueryWrapper<ProFeedback> query);


    @Select(value = "SELECT f.* FROM pro_feedback f\n" +
            "\tLEFT JOIN pro_task_workunit tw ON tw.task_workunit_id = f.task_workunit_id\n" +
            "${ew.customSqlSegment}")
    List<ProFeedbackDto> queryProFeedbackDtoJoinTaskWorkUnit(@Param("ew") QueryWrapper<ProFeedback> query);


    /**
     * 新增生产报工记录
     *
     * @param proFeedback 生产报工记录
     * @return 结果
     */
    int insertProFeedback(ProFeedback proFeedback);

    /**
     * 修改生产报工记录
     *
     * @param proFeedback 生产报工记录
     * @return 结果
     */
    int updateProFeedback(ProFeedback proFeedback);

    /**
     * 删除生产报工记录
     *
     * @param recordId 生产报工记录主键
     * @return 结果
     */
    int deleteProFeedbackByRecordId(Long recordId);

    /**
     * 批量删除生产报工记录
     *
     * @param recordIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProFeedbackByRecordIds(Long[] recordIds);


    @Select("select task_id, \n" +
            "       process_id,\n" +
            "\t\t\t sum(quantity_qualify) quantity_qualify\n" +
            "       from pro_feedback  \n" +
            "\t\t\t where task_id=#{taskId} and process_id=#{processId}\n" +
            "\t\t\t GROUP BY task_id, process_id")
    ProFeedback selectProFeedbackTaskIdProcessId(@Param("taskId") Long taskId, @Param("processId") Long processId);

    @Select(" select sum(quantity_feedback) quantity_feedback," +
            "sum(quantity_qualify) quantity_qualify, " +
            "sum(quantity_unqualify) quantity_unqualify, " +
            "sum(quantity_uncheck) quantity_uncheck" +
            "from pro_feedback  where task_id=#{taskId} and process_id=#{processId} GROUP BY task_id, process_id")
    ProProcessTaskVo selectProFeedbackFeedback(@Param("taskId") Long taskId, @Param("processId") Long processId);

    void updateAbnormal(@Param("abnormalId") Long abnormalId, @Param("abnormalReason")String abnormalReason, @Param("abnormalRemark")String abnormalRemark,@Param("abnormalType") String abnormalType,@Param("recordId") Long recordId);

    void updateLastFeedback(@Param("qrcode")String qrcode, @Param("taskId")Long taskId);

    List<FeedbackResponse> getList(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByWorkOrder(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByWorkshop(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByWorkstation(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByWorkunit(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByProcess(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByUser(FeedbackRequest feedbackRequest);

    List<FeedbackResponse> getListByDefect(FeedbackRequest feedbackRequest);

    int selectCount(@Param("taskIds")List<Long> taskIds);

    List<WorkOrderProgressFeedbackListResponse> getFeedbackList(@Param("workorderCode")String workorderCode,@Param("taskId") Long taskId,@Param("taskWorkunitId") Long taskWorkunitId);

    List<FeedbackResponseExportByList> export(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByWorkOrder> getListByWorkOrderExport(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByWorkshop> getListByWorkshopExport(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByWorkstation> getListByWorkstationExport(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByWorkunit> getListByWorkunitExport(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByProcess> getListByProcessExport(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByUser> getListByUserExport(FeedbackRequest feedbackRequest);

    List<FeedbackResponseExportByDefect> getListByDefectExport(FeedbackRequest feedbackRequest);
}
