package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProAllocationMaterial;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 调拨料申请Mapper接口
 *
 * @author generator
 * @date 2024-05-14
 */
public interface ProAllocationMaterialMapper extends BaseMapper<ProAllocationMaterial> {
    /**
     * 查询调拨料申请
     *
     * @param allocationMaterialId 调拨料申请主键
     * @return 调拨料申请
     */
    ProAllocationMaterial selectProAllocationMaterialByAllocationMaterialId(Long allocationMaterialId);

    /**
     * 查询调拨料申请列表
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 调拨料申请集合
     */
    List<ProAllocationMaterial> selectProAllocationMaterialList(ProAllocationMaterial proAllocationMaterial);
    /**
     * 查询调拨料申请列表
     *
     * @param query 调拨料申请
     * @return 调拨料申请集合
     */
    @Select("select * from pro_allocation_material" +
            " ${ew.customSqlSegment} \t\t")
    List<ProAllocationMaterial> selectProAllocationMaterialListByQw(@Param("ew") QueryWrapper<ProAllocationMaterial> query);

    /**
     * 新增调拨料申请
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 结果
     */
    int insertProAllocationMaterial(ProAllocationMaterial proAllocationMaterial);

    /**
     * 修改调拨料申请
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 结果
     */
    int updateProAllocationMaterial(ProAllocationMaterial proAllocationMaterial);

    /**
     * 删除调拨料申请
     *
     * @param allocationMaterialId 调拨料申请主键
     * @return 结果
     */
    int deleteProAllocationMaterialByAllocationMaterialId(Long allocationMaterialId);

    /**
     * 批量删除调拨料申请
     *
     * @param allocationMaterialIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProAllocationMaterialByAllocationMaterialIds(Long[] allocationMaterialIds);
}
