package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.AppConfig;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 作业端配置记录Mapper接口
 *
 * @author generator
 * @date 2024-06-24
 */
public interface AppConfigMapper extends BaseMapper<AppConfig> {
    /**
     * 查询作业端配置记录
     *
     * @param id 作业端配置记录主键
     * @return 作业端配置记录
     */
    AppConfig selectAppConfigById(Long id);

    /**
     * 查询作业端配置记录列表
     *
     * @param appConfig 作业端配置记录
     * @return 作业端配置记录集合
     */
    List<AppConfig> selectAppConfigList(AppConfig appConfig);

    /**
     * 新增作业端配置记录
     *
     * @param appConfig 作业端配置记录
     * @return 结果
     */
    int insertAppConfig(AppConfig appConfig);

    /**
     * 修改作业端配置记录
     *
     * @param appConfig 作业端配置记录
     * @return 结果
     */
    int updateAppConfig(AppConfig appConfig);

    /**
     * 删除作业端配置记录
     *
     * @param id 作业端配置记录主键
     * @return 结果
     */
    int deleteAppConfigById(Long id);

    /**
     * 批量删除作业端配置记录
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteAppConfigByIds(Long[] ids);

    @Select("select  * from app_config  ${ew.customSqlSegment} ")
    List<AppConfig> selectListByQw(@Param("ew") QueryWrapper<AppConfig> query);
}
