package com.ximai.mes.pro.dto;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品序列号打印记录对象 pro_product_qrcode_record
 *
 * @author generator
 * @date 2024-08-31
 */
@Data
public class ProProductQrcodeRecordExcelExport {
    private static final long serialVersionUID = 1L;

    /** ID */
    @TableId
    private Long recordId;

    /** 产品ID */
    @ApiModelProperty("产品ID")
    @Excel(name = "产品ID")
    private Long itemId;

    /** 产品编码 */
    @ApiModelProperty("产品编码")
    @Excel(name = "产品编码")
    private String itemCode;

    /** 工单ID */
    @ApiModelProperty("工单ID")
    @Excel(name = "工单ID")
    private Long workOrderId;

    /** 工单编号 */
    @ApiModelProperty("工单编号")
    @Excel(name = "工单编号")
    private String workOrderNo;

    /** 打印次数 */
    @ApiModelProperty("打印次数")
    @Excel(name = "打印次数")
    private Long printTime;

    /** 二维码 */
    @ApiModelProperty("二维码")
    @Excel(name = "二维码")
    private String qrcode;

    /** 客户编码 */
    @ApiModelProperty("客户编码")
    @Excel(name = "客户编码")
    private String clientCode;

    /** 客户名称 */
    @ApiModelProperty("客户名称")
    @Excel(name = "客户名称")
    private String clientName;

    /** 产品描述 */
    @ApiModelProperty("产品描述")
    @Excel(name = "产品描述")
    private String itemDesc;



}
