package com.ximai.mes.pro.domain.vo.proWorkOrder;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 工单包装信息
 *
 * @author chicheng.li
 * @date 2024-05-08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkorderPackage {

    /** 派工单ID */
    @Excel(name = "派工单ID")
    private Long taskWorkunitId;

    /** 工单ID */
    @Excel(name = "工单ID")
    private Long workorderId;

    /** 工单指令ID */
    @Excel(name = "工单指令ID")
    private Long workorderSoDirectiveId;

    /** 工单SIZE */
    @Excel(name = "工单SIZE")
    private Long workorderSoSizeItemId;

    /** 报工单ID */
    @Excel(name = "报工单ID")
    private Long feedbackId;

    /** 当前面码 */
    @ApiModelProperty("当前面码")
    private Integer sheetCount;

    @ApiModelProperty("二维码")
    private String qrcode;

    @ApiModelProperty("总页码")
    private Integer totalCount;

    @ApiModelProperty("包装数")
    private Integer packageNum=0;

    @ApiModelProperty("LOSS数")
    private Integer lossNum=0;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("录入人员")
    private String inputBy;

    @ApiModelProperty("检验人员")
    private String checkBy;

    @ApiModelProperty("打印次数")
    private Integer printTime;

    @ApiModelProperty("bl分组号")
    private Integer blGroup;

    private Integer index;

    @ApiModelProperty("箱包装/LOSS单独包装数量分布")
    List<QuantityDistribute> distributes;

    @ApiModelProperty("箱包装关联所属包装标签")
    List<WorkorderPackage> packageList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class QuantityDistribute{

        @ApiModelProperty("指令ID")
        Long directiveId;

        @ApiModelProperty("SIZEID")
        Long sizeId;

        @ApiModelProperty("包装数")
        private Integer packageNum;

        @ApiModelProperty("LOSS数")
        private Integer lossNum=0;
    }


}
