package com.ximai.mes.pro.domain.vo.proWorkOrder;

import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 生产工单对象 pro_workorder
 *
 * @date 2022-05-15
 */
@Data
public class ProWorkorderPrintTab extends BaseEntity {
    private static final long serialVersionUID = 1L;
    private WorkOrderTable workOrderTable;
    private ProductionSolutionTable productionSolutionTable;

    @Data
    public static class WorkOrderTable {
        private PageHeader pageHeader = new PageHeader();
        private PageFooter pageFooter = new PageFooter();
        private Body body = new Body();

        @Data
        public static class Body {
            WorkOrderInfo workOrderInfo = new WorkOrderInfo();
            List<Process> processList = new ArrayList<>();
            List<ProcessItem> processItemList = new ArrayList<>();
            List<SoDirective> soDirectives = new ArrayList<>();
            List<SoSize> soSizeList = new ArrayList<>();
            Img img = new Img();
        }


        @Data
        public static class WorkOrderInfo {
            // 产品编码
            private String productCode;
            // 产品名称
            private String productName;
            // 单位
            private String unit;
            // 生产数量
            private BigDecimal quantity;

            // loss数量
            private BigDecimal lossNum;

            // 参考数量
            private BigDecimal dispatchQuantity;
            // 派工数量
            private BigDecimal referenceQuantity;

            // 材料总重(KG)
            private BigDecimal materialWeight;
            // 单层厚(丝)
            private BigDecimal singleLayerThick;
        }


        @Data
        public static class SoDirective {
            // 产品材质
            private String productSpec;
            // 备注
            private String remark;
            // 印刷正面颜色
            private String frontColorName;
            // 印刷背面颜色
            private String oppositeColorName;
            // 尺码组
            private String sizeGroup;

            // 排版行数
            private String rowNum;

            // 段别
            private String segment;
            // 销线
            private String salePath;
            // 整/半码
            private String wholeSize;
            // 季度
            private String quarter;

            // PO号
            private String poNo;

            // WIPNo号
            private String wipNo;

            // sk编号
            private String skNo;

            // 专利号
            private String patentNo;

            // 材质描述
            private String materialDesc;

            // SHIP TO ID
            private String shipToId;

            // 周期
            private String cycle;

            // 装箱数
            private String packingNum;

        }

        @Data
        public static class SoSize {
            // 形体配色
            private String colorNo;
            // 指令
            private String clientCmd;
            // 数量
            private BigDecimal quantity;
            // loss数量
            private BigDecimal lossNum;

        }


        @Data
        public static class Img {
            // 产品正面
            private String frontImg;
            // 产品背面
            private String backImg;
        }

        @Data
        public static class Process {
            // 物料编码
            private String processName;
            // 备注
            private String remark;
            // 描述
            private String desc;
            // 数量
            private BigDecimal quantity;
        }

        @Data
        public static class ProcessItem {
            // 物料编码
            private String itemCode;
            // 物料分类
            private String itemType;
            // 物料名称
            private String itemName;
            // 单位
            private String unit;
            // 标准用量
            private BigDecimal standardDosage;
            // 订单用量
            private BigDecimal quantity;
            // 应用工序
            private String processName;
            // 备注
            private String remark;
        }

    }

    @Data
    public static class ProductionSolutionTable {
        private PageHeader pageHeader = new PageHeader();
        private PageFooter pageFooter = new PageFooter();
        // 规格编号
//        private String productSolutionCode;
        // 录入时间
//        private String entryTime;
        private Body body = new Body();

        @Data
        public static class Body {

            // 产品类别
            String itemTypeName;
            //  产品编码
            String itemCode;
            //  单位
            String unit;
            // 品牌
            String brandName;
            // 采购单位
            String purchaseUnit;
            // 换算值
            String conversionValue;
            // 尺码组
            private String sizeGroup;

            // 排版行数
            private Long rowNum;
            // 产品名称
            String itemName;


            // 样品单号  proofingWorkOrders
            String workorderProofingCode;


            // 英文名称
            String enName;
            //  长度cm
            BigDecimal length;

            // 单层厚(丝)
            BigDecimal singleLayerThick;

            // 单重kg
            BigDecimal singleWeight;

            // 层数
            BigDecimal layerNum;

            // 高度cm
            BigDecimal height;

            // 宽度cm
            BigDecimal width;

            // 印张长度cm
            BigDecimal printingPaperlenth;

            // 印张宽度cm
            BigDecimal printPaperwidth;


            // 仓库
            String storePlace;


            // 派工倍数
            BigDecimal dispatchMultiple;


            // 是否启用
            String isEnable;


            // 是否创建新规格书
            String isCreateSpec;


            // 是否要鞋图
            String isNeedShoeImg;


            // 是否附样品
            String isAddSimple;

            // 是否为唯一码产品
            String isUniqueCode;


            // 是否不考虑形体配色
            String isConsiderColor;


            // 产品材质
            String productMaterial;

            // 配方
            String formula;

            // 印刷正面颜色
            String frontColorName;


            // 印刷背面颜色
            String oppositeColorName;

            // 产品正面
            String frontImg;

            // 产品背面
            String backImg;


            // 客户审核人
            String customerApprover;
            // 客户审核时间
            String customerApprovedTime;
            // 研发审核人 研发
            String rDApproverd;
            String rDChecked;
            String rDPrepared;


            List<WorkOrderTable.Process> processes = new ArrayList<>();
        }

    }

    @Data
    public static class PageHeader {

        // 产品类别
        private String itemTypeName;

        // 编排单号
        private String arrangeCode;

        // 客户名称
        private String clientName;

        // 单据类型
        private final String tableTypeName = "直接出货单-正常单";

        // 生产版本编号(规格书编号)
        private String productionSolutionCode;

        //  完工时间
        private String finishTime;

        // 工艺要求
        private String routeDesc;
        private String processDesc;
        // 排版行数
        private String rowNum;

        // 派工倍数
        private BigDecimal dispatchMultiple;

        // 印刷方向
        private String printingDirection;

        // 材料总长度
        private BigDecimal materialLength;

        // 包装方式
        private String packMode;


    }


    @Data
    public static class PageFooter {
        // 打印人
        private String printUsername;
        // 输单员/审核员
        private String auditors;
        // 跟单员
        private String merchandiser;
        // 生管
        private String productionManagement;


        // 录入时间
        private String entryTime;
    }
}
