package com.ximai.mes.pro.domain.vo.proWorkOrder;

import cn.hutool.core.bean.BeanUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * 工单包装信息
 *
 * @author chicheng.li
 * @date 2024-05-26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PackageBasicResult {

    @ApiModelProperty("包装数")
    private Integer packageNum=0;

    @ApiModelProperty("LOSS数")
    private Integer lossNum=0;

    @ApiModelProperty("LOSS单独包装数量分布")
    List<QuantityDistribute> distributes = new ArrayList<QuantityDistribute>();

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class QuantityDistribute{

        @ApiModelProperty("ID")
        Long id;

        @ApiModelProperty("包装数")
        private Integer packageNum;

        @ApiModelProperty("LOSS数")
        private Integer lossNum=0;
    }

    public PackageBasicResult copyAppend(List<PackageBasicResult> tempList){
        PackageBasicResult tempRst = new PackageBasicResult();
        BeanUtil.copyProperties(this, tempRst);
        tempList.add(tempRst);
        this.setDistributes(new ArrayList<QuantityDistribute>());
        return tempRst;
    }

}
